/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.core.config.modifiers;

import com.gigaspaces.client.SpaceProxyOperationModifiers;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.core.Constants;

public abstract class AbstractSpaceProxyOperationModifierFactoryBean<T extends SpaceProxyOperationModifiers>
implements FactoryBean<T> {
    private final Class<T> objectType;
    private T modifier;

    public AbstractSpaceProxyOperationModifierFactoryBean(Class<T> objectType) {
        this.objectType = objectType;
    }

    public void setModifierName(String modifierName) {
        Constants constants = this.getConstants();
        if (!constants.getNames("").contains(modifierName)) {
            throw new IllegalArgumentException("Unknown modifier: " + modifierName + " for type: " + this.getObjectType());
        }
        this.modifier = (SpaceProxyOperationModifiers)constants.asObject(modifierName);
    }

    public Class<T> getObjectType() {
        return this.objectType;
    }

    public T getObject() throws Exception {
        return this.modifier;
    }

    public boolean isSingleton() {
        return true;
    }

    protected abstract Constants getConstants();
}

