/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.core.config.xmlparser;

import javax.xml.bind.annotation.XmlRootElement;
import org.openspaces.core.config.xmlparser.XmlBeanDefinitionParser;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.NamespaceHandlerSupport;

public abstract class AbstractXmlBeanNamespaceHandler
extends NamespaceHandlerSupport {
    protected void register(Class<?> clazz) {
        String elementName;
        XmlRootElement rootElement = clazz.getAnnotation(XmlRootElement.class);
        if (rootElement == null || rootElement.name().equals("##default")) {
            elementName = AbstractXmlBeanNamespaceHandler.convertClassNameToAttributeName(clazz.getSimpleName());
        } else {
            elementName = rootElement.name();
            if (elementName == null || elementName.length() == 0) {
                throw new IllegalArgumentException("Class " + clazz.getName() + " " + XmlRootElement.class.getName() + " annotation name cannot be null or empty");
            }
        }
        this.registerBeanDefinitionParser(elementName, (BeanDefinitionParser)new XmlBeanDefinitionParser(clazz));
    }

    private static String convertClassNameToAttributeName(String classname) {
        StringBuilder attributeName = new StringBuilder();
        if (classname.isEmpty()) {
            throw new IllegalArgumentException("classname cannot be empty");
        }
        if (!Character.isUpperCase(classname.charAt(0))) {
            throw new IllegalArgumentException("classname " + classname + " must start with an uppercase letter");
        }
        for (int i = 0; i < classname.length(); ++i) {
            char c = classname.charAt(i);
            if (Character.isUpperCase(c) && i > 0) {
                attributeName.append('-').append(Character.toLowerCase(c));
                continue;
            }
            attributeName.append(Character.toLowerCase(c));
        }
        return attributeName.toString();
    }
}

