/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.core.config.xmlparser;

import org.openspaces.core.space.SecurityConfig;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

public class SecurityDefinitionsParser {
    private static final String USERNAME = "username";
    private static final String PASSWORD = "password";
    private static final String USER_DETAILS = "user-details";
    private static final String CREDENTIALS_PROVIDER = "credentials-provider";

    public static void parseXml(Element securityElement, BeanDefinitionBuilder builder) {
        String credentialsProviderRef;
        String userDetailsRef;
        String username = securityElement.getAttribute(USERNAME);
        String password = securityElement.getAttribute(PASSWORD);
        if (StringUtils.hasText((String)username)) {
            SecurityConfig securityConfig = new SecurityConfig();
            securityConfig.setUsername(username);
            if (StringUtils.hasText((String)password)) {
                securityConfig.setPassword(password);
            }
            if (securityConfig != null) {
                builder.addPropertyValue("securityConfig", (Object)securityConfig);
            }
        }
        if (StringUtils.hasText((String)(userDetailsRef = securityElement.getAttribute(USER_DETAILS)))) {
            builder.addPropertyReference("userDetails", userDetailsRef);
        }
        if (StringUtils.hasText((String)(credentialsProviderRef = securityElement.getAttribute(CREDENTIALS_PROVIDER)))) {
            builder.addPropertyReference("credentialsProvider", credentialsProviderRef);
        }
    }
}

