/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.core.config.xmlparser;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElements;
import javax.xml.bind.annotation.XmlTransient;

public class XmlAnnotationExtractor {
    private final Class<?> clazz;
    private final Map<String, Method> methodPerAttributeName = new HashMap<String, Method>();
    private final Map<Class<?>, Method> methodPerChildElementType = new HashMap();
    private final Map<String, Method> methodPerChildElementName = new HashMap<String, Method>();

    public Map<String, Method> getMethodPerAttributeName() {
        return this.methodPerAttributeName;
    }

    public Map<String, Method> getMethodPerChildElementName() {
        return this.methodPerChildElementName;
    }

    public Map<Class<?>, Method> getMethodPerChildElementType() {
        return this.methodPerChildElementType;
    }

    public XmlAnnotationExtractor(Class<?> clazz) {
        this.clazz = clazz;
        for (Method method : clazz.getMethods()) {
            XmlElements xmlElementsAnnotation;
            XmlElement xmlElementAnnotation;
            XmlTransient xmlTransient = method.getAnnotation(XmlTransient.class);
            if (xmlTransient != null) continue;
            XmlAttribute xmlAttributeAnnotation = method.getAnnotation(XmlAttribute.class);
            if (xmlAttributeAnnotation != null) {
                XmlAnnotationExtractor.validateSetterMethod(method);
                String name = xmlAttributeAnnotation.name();
                if (name.equals("##default")) {
                    name = this.getXmlNameFromMethodName(method);
                }
                this.putMethodByAttributeName(name, method);
            }
            if ((xmlElementAnnotation = method.getAnnotation(XmlElement.class)) != null) {
                this.handleXmlElementAnnotation(method, xmlElementAnnotation);
            }
            if ((xmlElementsAnnotation = method.getAnnotation(XmlElements.class)) != null) {
                for (XmlElement innerXmlElementAnnotation : xmlElementsAnnotation.value()) {
                    if (innerXmlElementAnnotation == null) continue;
                    this.handleXmlElementAnnotation(method, innerXmlElementAnnotation);
                }
            }
            if (xmlAttributeAnnotation != null || xmlElementAnnotation != null || xmlElementsAnnotation != null || !XmlAnnotationExtractor.isSetterMethod(method)) continue;
            String name = this.getXmlNameFromMethodName(method);
            if (this.isAssignableFromString(method)) {
                this.putMethodByAttributeName(name, method);
                continue;
            }
            this.putMethodByElementName(name, method);
        }
    }

    private void handleXmlElementAnnotation(Method method, XmlElement xmlElementAnnotation) {
        XmlAnnotationExtractor.validateSetterMethod(method);
        boolean defaultName = xmlElementAnnotation.name().equals("##default");
        boolean defaultType = xmlElementAnnotation.type().equals(XmlElement.DEFAULT.class);
        if (!defaultName) {
            this.putMethodByElementName(xmlElementAnnotation.name(), method);
        } else if (!defaultType) {
            this.putMethodByElementType(xmlElementAnnotation.type(), method);
        } else {
            this.putMethodByElementName(this.getXmlNameFromMethodName(method), method);
        }
    }

    private boolean isAssignableFromString(Method method) {
        Class<?> type = method.getParameterTypes()[0];
        if (type.isPrimitive()) {
            return true;
        }
        for (Constructor<?> cotr : type.getConstructors()) {
            if (cotr.getParameterTypes().length != 1 || !cotr.getParameterTypes()[0].equals(String.class)) continue;
            return true;
        }
        return type.isArray() && String.class.isAssignableFrom(type.getComponentType());
    }

    private String getXmlNameFromMethodName(Method method) {
        String propertyName = this.convertSetterMethodToPropertyName(method);
        String attributeName = XmlAnnotationExtractor.convertPropertyNameToAttributeName(propertyName);
        return attributeName;
    }

    private void putMethodByElementName(String elementName, Method method) {
        if (this.methodPerChildElementName.containsKey(elementName)) {
            throw new IllegalStateException(XmlElement.class.getName() + " conflict in class " + this.clazz.getName() + ". " + elementName + " defined both in method " + method.getName() + " and " + this.methodPerAttributeName.get(elementName).getName());
        }
        this.methodPerChildElementName.put(elementName, method);
    }

    private void putMethodByAttributeName(String attributeName, Method method) {
        if (this.methodPerAttributeName.containsKey(attributeName)) {
            throw new IllegalStateException(XmlAttribute.class.getName() + " conflict in class " + this.clazz.getName() + ". " + attributeName + " defined both in method " + method.getName() + " and " + this.methodPerAttributeName.get(attributeName).getName());
        }
        this.methodPerAttributeName.put(attributeName, method);
    }

    private Method putMethodByElementType(Class<?> type, Method method) {
        if (this.methodPerChildElementType.containsKey(type)) {
            throw new IllegalStateException(XmlElement.class.getName() + " conflict in class " + this.clazz.getName() + ". Type " + type.getName() + " defined both in method " + method.getName() + " and " + this.methodPerChildElementType.get(type).getName());
        }
        return this.methodPerChildElementType.put(type, method);
    }

    private String convertSetterMethodToPropertyName(Method method) {
        String methodName = method.getName();
        String propertyName = String.valueOf(methodName.charAt(3)).toLowerCase() + methodName.substring(4);
        return propertyName;
    }

    private static boolean isSetterMethod(Method method) {
        return method.getName().startsWith("set") && method.getParameterTypes().length == 1;
    }

    private static void validateSetterMethod(Method method) {
        if (!method.getName().startsWith("set")) {
            throw new IllegalArgumentException(method.getName() + " must start with 'set' prefix or use a value for the @XmlProperty annotation");
        }
        if (method.getParameterTypes().length != 1) {
            throw new IllegalStateException("Method " + method.getName() + " must have a single parameter since it is marked with the " + XmlAttribute.class.getName() + " attribute");
        }
    }

    private static String convertPropertyNameToAttributeName(String propertyName) {
        StringBuilder attributeName = new StringBuilder();
        if (propertyName.isEmpty()) {
            throw new IllegalArgumentException("propertyName cannot be empty");
        }
        if (Character.isUpperCase(propertyName.charAt(0))) {
            throw new IllegalArgumentException("propertyName " + propertyName + " must start with a lowercase letter");
        }
        for (int i = 0; i < propertyName.length(); ++i) {
            char c = propertyName.charAt(i);
            if (Character.isUpperCase(c)) {
                attributeName.append('-').append(Character.toLowerCase(c));
                continue;
            }
            attributeName.append(c);
        }
        return attributeName.toString();
    }
}

