/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.core.config.xmlparser;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openspaces.core.config.xmlparser.XmlAnnotationExtractor;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.xml.AbstractSingleBeanDefinitionParser;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;

public class XmlBeanDefinitionParser
extends AbstractSingleBeanDefinitionParser {
    private final Class<?> clazz;
    private final XmlAnnotationExtractor annotations;

    protected Class<?> getBeanClass(Element element) {
        return this.clazz;
    }

    public XmlBeanDefinitionParser(Class<?> clazz) {
        this.clazz = clazz;
        this.annotations = new XmlAnnotationExtractor(clazz);
    }

    protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        NamedNodeMap attributes = element.getAttributes();
        for (int i = 0; i < attributes.getLength(); ++i) {
            Attr attribute = (Attr)attributes.item(i);
            String string = attribute.getName();
            Method method = this.annotations.getMethodPerAttributeName().get(string);
            if (method == null) continue;
            String propertyName = XmlBeanDefinitionParser.convertSetterMethodToPropertyName(method);
            String value = attribute.getValue();
            builder.addPropertyValue(propertyName, (Object)value);
        }
        HashMap<Method, ManagedList> listValues = new HashMap<Method, ManagedList>();
        for (Element element2 : DomUtils.getChildElements((Element)element)) {
            String childName = element2.getLocalName();
            Object value = parserContext.getDelegate().parsePropertySubElement(element2, (BeanDefinition)builder.getRawBeanDefinition());
            Method method = this.annotations.getMethodPerChildElementName().get(childName);
            if (method == null) {
                Class valueType = null;
                if (value instanceof BeanDefinitionHolder) {
                    String beanClassName = ((BeanDefinitionHolder)value).getBeanDefinition().getBeanClassName();
                    try {
                        valueType = Class.forName(beanClassName);
                    }
                    catch (ClassNotFoundException e) {
                        throw new IllegalStateException("Cannot find class " + beanClassName + " inferred from xml " + childName, e);
                    }
                } else if (value instanceof List) {
                    valueType = List.class;
                }
                if (valueType != null) {
                    for (Map.Entry<Class<?>, Method> pair : this.annotations.getMethodPerChildElementType().entrySet()) {
                        if (!pair.getKey().isAssignableFrom(valueType)) continue;
                        method = pair.getValue();
                        break;
                    }
                }
            }
            if (method == null) continue;
            if (!XmlBeanDefinitionParser.isListSetterMethod(method)) {
                String propertyName = XmlBeanDefinitionParser.convertSetterMethodToPropertyName(method);
                builder.addPropertyValue(propertyName, value);
                continue;
            }
            ManagedList values = (ManagedList)listValues.get(method);
            if (values == null) {
                values = new ManagedList();
            }
            values.add(value);
            listValues.put(method, values);
        }
        for (Map.Entry entry : listValues.entrySet()) {
            String propertyName = XmlBeanDefinitionParser.convertSetterMethodToPropertyName((Method)entry.getKey());
            builder.addPropertyValue(propertyName, entry.getValue());
        }
    }

    protected boolean shouldGenerateIdAsFallback() {
        return true;
    }

    private static String convertSetterMethodToPropertyName(Method method) {
        String methodName = method.getName();
        if (!methodName.startsWith("set")) {
            throw new IllegalArgumentException(methodName + " does not start with 'set':" + methodName);
        }
        return String.valueOf(methodName.charAt(3)).toLowerCase() + methodName.substring(4);
    }

    private static boolean isListSetterMethod(Method method) {
        Class<?> type = method.getParameterTypes()[0];
        return type.equals(List.class) || type.isArray();
    }
}

