/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.core.context;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openspaces.core.GigaSpace;
import org.openspaces.core.context.GigaSpaceContext;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.config.InstantiationAwareBeanPostProcessorAdapter;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.util.ReflectionUtils;

public class GigaSpaceContextBeanPostProcessor
extends InstantiationAwareBeanPostProcessorAdapter
implements ApplicationContextAware {
    protected final Log logger = LogFactory.getLog(((Object)((Object)this)).getClass());
    private ApplicationContext applicationContext;
    private Map<Class<?>, List<AnnotatedMember>> classMetadata = new HashMap();
    private Map<String, GigaSpace> gsByName;
    private GigaSpace uniqueGs;

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    private synchronized void initMapsIfNecessary() {
        if (this.gsByName == null) {
            this.gsByName = new HashMap<String, GigaSpace>();
            for (String gsName : BeanFactoryUtils.beanNamesForTypeIncludingAncestors((ListableBeanFactory)this.applicationContext, GigaSpace.class)) {
                GigaSpace gs = (GigaSpace)this.applicationContext.getBean(gsName);
                this.gsByName.put(gsName, gs);
            }
            if (this.gsByName.isEmpty()) {
                String[] gsNames = BeanFactoryUtils.beanNamesForTypeIncludingAncestors((ListableBeanFactory)this.applicationContext, GigaSpace.class);
                if (gsNames.length == 1) {
                    this.uniqueGs = (GigaSpace)this.applicationContext.getBean(gsNames[0]);
                }
            } else if (this.gsByName.size() == 1) {
                this.uniqueGs = this.gsByName.values().iterator().next();
            }
            if (this.gsByName.isEmpty() && this.uniqueGs == null) {
                this.logger.warn((Object)"No named gs instances defined and not exactly one anonymous one: cannot inject");
            }
        }
    }

    protected GigaSpace findGigaSpaceByName(String gsName) throws NoSuchBeanDefinitionException {
        this.initMapsIfNecessary();
        if (gsName == null || "".equals(gsName)) {
            if (this.uniqueGs != null) {
                return this.uniqueGs;
            }
            throw new NoSuchBeanDefinitionException("No GigaSpaces name given and factory contains several");
        }
        GigaSpace namedGs = this.gsByName.get(gsName);
        if (namedGs == null) {
            throw new NoSuchBeanDefinitionException("No GigaSpaces found for name [" + gsName + "]");
        }
        return namedGs;
    }

    public boolean postProcessAfterInstantiation(Object bean, String beanName) throws BeansException {
        if (bean == null) {
            return true;
        }
        List<AnnotatedMember> metadata = this.findClassMetadata(bean.getClass());
        for (AnnotatedMember member : metadata) {
            member.inject(bean);
        }
        return true;
    }

    private synchronized List<AnnotatedMember> findClassMetadata(Class<?> clazz) {
        List<AnnotatedMember> metadata = this.classMetadata.get(clazz);
        if (metadata == null) {
            final LinkedList<AnnotatedMember> newMetadata = new LinkedList<AnnotatedMember>();
            ReflectionUtils.doWithFields(clazz, (ReflectionUtils.FieldCallback)new ReflectionUtils.FieldCallback(){

                public void doWith(Field f) {
                    GigaSpaceContextBeanPostProcessor.this.addIfPresent(newMetadata, f);
                }
            });
            ReflectionUtils.doWithMethods(clazz, (ReflectionUtils.MethodCallback)new ReflectionUtils.MethodCallback(){

                public void doWith(Method m) {
                    GigaSpaceContextBeanPostProcessor.this.addIfPresent(newMetadata, m);
                }
            });
            metadata = newMetadata;
            this.classMetadata.put(clazz, metadata);
        }
        return metadata;
    }

    private void addIfPresent(List<AnnotatedMember> metadata, AccessibleObject ao) {
        GigaSpaceContext gsContext = ao.getAnnotation(GigaSpaceContext.class);
        if (gsContext != null) {
            metadata.add(new AnnotatedMember(gsContext.name(), ao));
        }
    }

    private class AnnotatedMember {
        private final String name;
        private final AccessibleObject member;

        public AnnotatedMember(String name, AccessibleObject member) {
            this.name = name;
            this.member = member;
            Class<?> memberType = this.getMemberType();
            if (!GigaSpace.class.isAssignableFrom(memberType)) {
                throw new IllegalArgumentException("Cannot inject [" + member + "], not a supported GigaSpaces type");
            }
        }

        public void inject(Object instance) {
            block6: {
                Object value = this.resolve();
                try {
                    if (!this.member.isAccessible()) {
                        this.member.setAccessible(true);
                    }
                    if (this.member instanceof Field) {
                        ((Field)this.member).set(instance, value);
                        break block6;
                    }
                    if (this.member instanceof Method) {
                        ((Method)this.member).invoke(instance, value);
                        break block6;
                    }
                    throw new IllegalArgumentException("Cannot inject unknown AccessibleObject type " + this.member);
                }
                catch (IllegalAccessException ex) {
                    throw new IllegalArgumentException("Cannot inject member " + this.member, ex);
                }
                catch (InvocationTargetException ex) {
                    throw new IllegalArgumentException("Attempt to inject setter method " + this.member + " resulted in an exception", ex);
                }
            }
        }

        public Class<?> getMemberType() {
            if (this.member instanceof Field) {
                return ((Field)this.member).getType();
            }
            if (this.member instanceof Method) {
                Method setter = (Method)this.member;
                if (setter.getParameterTypes().length != 1) {
                    throw new IllegalArgumentException("Supposed setter " + this.member + " must have 1 argument, not " + setter.getParameterTypes().length);
                }
                return setter.getParameterTypes()[0];
            }
            throw new IllegalArgumentException("Unknown AccessibleObject type " + this.member.getClass() + "; Can only inject setter methods or fields");
        }

        protected Object resolve() {
            GigaSpace gs = GigaSpaceContextBeanPostProcessor.this.findGigaSpaceByName(this.name);
            if (GigaSpace.class.isAssignableFrom(this.getMemberType())) {
                if (!this.getMemberType().isInstance(gs)) {
                    throw new IllegalArgumentException("Cannot inject " + this.member + " with GigaSpaces [" + this.name + "]: type mismatch");
                }
                return gs;
            }
            throw new IllegalArgumentException("Failure to inject");
        }
    }
}

