/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.core.exception;

import com.gigaspaces.client.protective.ProtectiveModeException;
import com.gigaspaces.internal.metadata.converter.ConversionException;
import com.gigaspaces.security.SecurityException;
import com.j_spaces.core.MemoryShortageException;
import com.j_spaces.core.TransactionNotActiveException;
import com.j_spaces.core.client.CacheException;
import com.j_spaces.core.client.CacheTimeoutException;
import com.j_spaces.core.client.DuplicateIndexValueException;
import com.j_spaces.core.client.EntryVersionConflictException;
import com.j_spaces.core.client.OperationTimeoutException;
import com.j_spaces.core.client.sql.SQLQueryException;
import com.j_spaces.core.exception.ClosedResourceException;
import java.rmi.RemoteException;
import org.openspaces.core.BadSqlQueryException;
import org.openspaces.core.ChangeException;
import org.openspaces.core.ClearException;
import org.openspaces.core.ConsistencyLevelViolationException;
import org.openspaces.core.EntryAlreadyInSpaceException;
import org.openspaces.core.EntryLockedException;
import org.openspaces.core.EntryNotInSpaceException;
import org.openspaces.core.EntrySerializationException;
import org.openspaces.core.InactiveTransactionException;
import org.openspaces.core.InternalSpaceException;
import org.openspaces.core.InvalidFifoClassException;
import org.openspaces.core.InvalidFifoTemplateException;
import org.openspaces.core.InvalidTransactionUsageException;
import org.openspaces.core.ObjectConversionException;
import org.openspaces.core.ReadByIdsException;
import org.openspaces.core.ReadMultipleException;
import org.openspaces.core.RedoLogCapacityExceededException;
import org.openspaces.core.RemoteDataAccessException;
import org.openspaces.core.ResourceCapacityExceededException;
import org.openspaces.core.SecurityAccessException;
import org.openspaces.core.SpaceClosedException;
import org.openspaces.core.SpaceInterruptedException;
import org.openspaces.core.SpaceMemoryShortageException;
import org.openspaces.core.SpaceMetadataException;
import org.openspaces.core.SpaceOptimisticLockingFailureException;
import org.openspaces.core.SpaceTimeoutException;
import org.openspaces.core.SpaceUnavailableException;
import org.openspaces.core.TakeByIdsException;
import org.openspaces.core.TakeMultipleException;
import org.openspaces.core.TransactionDataAccessException;
import org.openspaces.core.UncategorizedSpaceException;
import org.openspaces.core.UniqueConstraintViolationException;
import org.openspaces.core.UnusableEntryException;
import org.openspaces.core.UpdateOperationTimeoutException;
import org.openspaces.core.WriteMultipleException;
import org.openspaces.core.exception.ExceptionTranslator;
import org.springframework.dao.DataAccessException;
import org.springframework.transaction.TransactionException;

public class DefaultExceptionTranslator
implements ExceptionTranslator {
    @Override
    public DataAccessException translate(Throwable e) {
        DataAccessException dae = this.internalTranslate(e);
        if (dae != null) {
            return dae;
        }
        if (e instanceof ProtectiveModeException) {
            throw new ProtectiveModeException(e.getMessage(), e);
        }
        if (e instanceof RuntimeException) {
            throw (RuntimeException)e;
        }
        return new UncategorizedSpaceException(e.getMessage(), e);
    }

    @Override
    public DataAccessException translateNoUncategorized(Throwable e) {
        return this.internalTranslate(e);
    }

    private DataAccessException internalTranslate(Throwable e) {
        if (e == null) {
            return null;
        }
        if (e instanceof DuplicateIndexValueException) {
            return new UniqueConstraintViolationException(e.toString(), e);
        }
        if (e instanceof DataAccessException) {
            return (DataAccessException)e;
        }
        if (e instanceof TransactionException) {
            return new TransactionDataAccessException((TransactionException)e);
        }
        if (e instanceof CacheException) {
            if (e instanceof CacheTimeoutException) {
                return new SpaceTimeoutException(e.getMessage(), e);
            }
            Throwable cause = e.getCause();
            if (cause != null) {
                return this.internalTranslate(cause);
            }
            return null;
        }
        if (e instanceof InterruptedException) {
            return new SpaceInterruptedException(e.getMessage(), (InterruptedException)e);
        }
        if (e instanceof net.jini.space.InternalSpaceException) {
            DataAccessException dae;
            if (e.getCause() != null && (dae = this.internalTranslate(e.getCause())) != null) {
                return dae;
            }
            return new InternalSpaceException((net.jini.space.InternalSpaceException)e);
        }
        if (e instanceof RemoteException) {
            DataAccessException dae;
            RemoteException remoteException = (RemoteException)e;
            if (remoteException.getCause() != null && (dae = this.internalTranslate(remoteException.getCause())) != null) {
                return dae;
            }
            return new RemoteDataAccessException(remoteException);
        }
        if (e instanceof ClosedResourceException) {
            return new SpaceClosedException((ClosedResourceException)e);
        }
        if (e instanceof com.j_spaces.core.exception.SpaceUnavailableException) {
            return new SpaceUnavailableException((com.j_spaces.core.exception.SpaceUnavailableException)e);
        }
        if (e instanceof ConversionException) {
            return new ObjectConversionException((ConversionException)e);
        }
        if (e instanceof com.gigaspaces.metadata.SpaceMetadataException) {
            return new SpaceMetadataException(e.getMessage(), e.getCause());
        }
        if (e instanceof com.gigaspaces.client.WriteMultipleException) {
            return new WriteMultipleException((com.gigaspaces.client.WriteMultipleException)e, this);
        }
        if (e instanceof com.gigaspaces.client.ClearException) {
            return new ClearException((com.gigaspaces.client.ClearException)e, (ExceptionTranslator)this);
        }
        if (e instanceof com.gigaspaces.client.ReadMultipleException) {
            return new ReadMultipleException((com.gigaspaces.client.ReadMultipleException)e, (ExceptionTranslator)this);
        }
        if (e instanceof com.gigaspaces.client.ReadByIdsException) {
            return new ReadByIdsException((com.gigaspaces.client.ReadByIdsException)e, this);
        }
        if (e instanceof com.gigaspaces.client.TakeByIdsException) {
            return new TakeByIdsException((com.gigaspaces.client.TakeByIdsException)e, this);
        }
        if (e instanceof com.gigaspaces.client.TakeMultipleException) {
            return new TakeMultipleException((com.gigaspaces.client.TakeMultipleException)e, (ExceptionTranslator)this);
        }
        if (e instanceof SQLQueryException) {
            return new BadSqlQueryException((SQLQueryException)e);
        }
        if (e instanceof EntryVersionConflictException) {
            return new SpaceOptimisticLockingFailureException((EntryVersionConflictException)e);
        }
        if (e instanceof com.j_spaces.core.client.EntryNotInSpaceException) {
            return new EntryNotInSpaceException((com.j_spaces.core.client.EntryNotInSpaceException)e);
        }
        if (e instanceof com.j_spaces.core.client.EntryAlreadyInSpaceException) {
            return new EntryAlreadyInSpaceException((com.j_spaces.core.client.EntryAlreadyInSpaceException)e);
        }
        if (e instanceof com.j_spaces.core.InvalidFifoTemplateException) {
            return new InvalidFifoTemplateException((com.j_spaces.core.InvalidFifoTemplateException)e);
        }
        if (e instanceof com.j_spaces.core.InvalidFifoClassException) {
            return new InvalidFifoClassException((com.j_spaces.core.InvalidFifoClassException)e);
        }
        if (e instanceof net.jini.core.entry.UnusableEntryException) {
            return new UnusableEntryException((net.jini.core.entry.UnusableEntryException)e);
        }
        if (e instanceof net.jini.core.transaction.TransactionException) {
            if (e.getMessage().indexOf("not active") > -1) {
                return new InactiveTransactionException((net.jini.core.transaction.TransactionException)e);
            }
            if (e.getMessage().indexOf("wrong") > -1) {
                return new InvalidTransactionUsageException((net.jini.core.transaction.TransactionException)e);
            }
            return new TransactionDataAccessException((net.jini.core.transaction.TransactionException)e);
        }
        if (e instanceof TransactionNotActiveException) {
            return new InactiveTransactionException((TransactionNotActiveException)e);
        }
        if (e instanceof com.j_spaces.core.EntrySerializationException) {
            return new EntrySerializationException((com.j_spaces.core.EntrySerializationException)e);
        }
        if (e instanceof MemoryShortageException) {
            return new SpaceMemoryShortageException((MemoryShortageException)e);
        }
        if (e instanceof com.gigaspaces.client.EntryLockedException) {
            return new EntryLockedException(e.getMessage(), e);
        }
        if (e instanceof OperationTimeoutException) {
            return new UpdateOperationTimeoutException((OperationTimeoutException)e);
        }
        if (e instanceof SecurityException) {
            return new SecurityAccessException(e);
        }
        if (e instanceof com.gigaspaces.cluster.replication.RedoLogCapacityExceededException) {
            return new RedoLogCapacityExceededException((com.gigaspaces.cluster.replication.RedoLogCapacityExceededException)e);
        }
        if (e instanceof com.gigaspaces.client.ResourceCapacityExceededException) {
            return new ResourceCapacityExceededException((com.gigaspaces.client.ResourceCapacityExceededException)e);
        }
        if (e instanceof com.gigaspaces.client.ChangeException) {
            return new ChangeException((com.gigaspaces.client.ChangeException)e, this);
        }
        if (e instanceof com.gigaspaces.cluster.replication.ConsistencyLevelViolationException) {
            return new ConsistencyLevelViolationException((com.gigaspaces.cluster.replication.ConsistencyLevelViolationException)e);
        }
        return null;
    }
}

