/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.core.executor;

import com.gigaspaces.async.AsyncResultFilter;
import com.gigaspaces.async.AsyncResultsReducer;
import java.io.Serializable;
import java.util.concurrent.Callable;
import org.openspaces.core.GigaSpace;
import org.openspaces.core.executor.DistributedTask;
import org.openspaces.core.executor.Task;
import org.openspaces.core.executor.juc.CallableDistributedTaskAdapter;
import org.openspaces.core.executor.juc.CallableTaskAdapter;
import org.openspaces.core.executor.juc.DefaultTaskExecutorService;
import org.openspaces.core.executor.juc.RunnableDistributedTaskAdapter;
import org.openspaces.core.executor.juc.RunnableTaskAdapter;
import org.openspaces.core.executor.juc.TaskExecutorService;
import org.openspaces.core.executor.support.PrivilegedDistributedTask;
import org.openspaces.core.executor.support.PrivilegedTask;

public class TaskExecutors {
    public static TaskExecutorService newExecutorService(GigaSpace gigaSpace) {
        return new DefaultTaskExecutorService(gigaSpace);
    }

    public static <T extends Serializable> Task<T> task(Callable<T> callable) {
        return new CallableTaskAdapter<T>(callable);
    }

    public static <T extends Serializable, R> DistributedTask<T, R> task(Callable<T> callable, AsyncResultsReducer<T, R> reducer) {
        return new CallableDistributedTaskAdapter<T, R>(callable, reducer);
    }

    public static <T extends Serializable, R> DistributedTask<T, R> task(Callable<T> callable, AsyncResultsReducer<T, R> reducer, AsyncResultFilter<T> filter) {
        return new CallableDistributedTaskAdapter<T, R>(callable, reducer, filter);
    }

    public static <T extends Serializable> Task<T> task(Runnable runnable) {
        return new RunnableTaskAdapter(runnable);
    }

    public static <T extends Serializable, R> DistributedTask<T, R> task(Runnable runnable, AsyncResultsReducer<T, R> reducer) {
        return new RunnableDistributedTaskAdapter<T, R>(runnable, reducer);
    }

    public static <T extends Serializable, R> DistributedTask<T, R> task(Runnable runnable, AsyncResultsReducer<T, R> reducer, AsyncResultFilter<T> filter) {
        return new RunnableDistributedTaskAdapter<T, R>(runnable, reducer, filter);
    }

    public static <T extends Serializable, R> DistributedTask<T, R> task(Runnable runnable, T result, AsyncResultsReducer<T, R> reducer) {
        return new RunnableDistributedTaskAdapter<T, R>(runnable, result, reducer);
    }

    public static <T extends Serializable, R> DistributedTask<T, R> task(Runnable runnable, T result, AsyncResultsReducer<T, R> reducer, AsyncResultFilter<T> filter) {
        return new RunnableDistributedTaskAdapter<T, R>(runnable, result, reducer, filter);
    }

    public static <T extends Serializable> Task<T> task(Runnable runnable, T result) {
        return new RunnableTaskAdapter<T>(runnable, result);
    }

    public static <T extends Serializable> Task<T> privilegedTask(Task<T> task) {
        return new PrivilegedTask<T>(task);
    }

    public static <T extends Serializable, R> DistributedTask<T, R> privilegedTask(DistributedTask<T, R> task) {
        return new PrivilegedDistributedTask<T, R>(task);
    }

    public static <T extends Serializable, R> DistributedTask<T, R> privilegedTask(DistributedTask<T, R> task, AsyncResultFilter<T> filter) {
        return new PrivilegedDistributedTask<T, R>(task, filter);
    }
}

