/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.core.executor.internal;

import com.gigaspaces.annotation.pojo.SpaceRouting;
import com.gigaspaces.internal.reflection.IMethod;
import com.gigaspaces.internal.reflection.ReflectionUtil;
import com.gigaspaces.internal.utils.collections.CopyOnUpdateMap;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import org.openspaces.core.executor.TaskRoutingProvider;
import org.springframework.dao.DataAccessException;

public class ExecutorMetaDataProvider {
    private Map<Class, IMethod> routingMethods = new CopyOnUpdateMap();
    private static IMethod NO_METHOD;

    public Object findRouting(Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof TaskRoutingProvider) {
            return ((TaskRoutingProvider)obj).getRouting();
        }
        IMethod method = this.routingMethods.get(obj.getClass());
        if (method == null) {
            method = ExecutorMetaDataProvider.findRoutingMethod(obj);
            this.routingMethods.put(obj.getClass(), method);
        }
        if (method == NO_METHOD) {
            return null;
        }
        try {
            return method.invoke(obj, new Object[0]);
        }
        catch (IllegalAccessException e) {
            throw new FailedToExecuteRoutingMethodException(e.getMessage(), e);
        }
        catch (InvocationTargetException e) {
            throw new FailedToExecuteRoutingMethodException(e.getTargetException().getMessage(), e.getTargetException());
        }
    }

    private static IMethod findRoutingMethod(Object task) {
        Class<?> targetClass = task.getClass();
        do {
            Method[] methods;
            for (Method method : methods = targetClass.getDeclaredMethods()) {
                if (!method.isAnnotationPresent(SpaceRouting.class)) continue;
                method.setAccessible(true);
                return ReflectionUtil.createMethod((Method)method);
            }
        } while ((targetClass = targetClass.getSuperclass()) != null);
        return NO_METHOD;
    }

    static {
        try {
            NO_METHOD = ReflectionUtil.createMethod((Method)Object.class.getMethod("toString", new Class[0]));
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
    }

    public static class FailedToExecuteRoutingMethodException
    extends DataAccessException {
        private static final long serialVersionUID = -3598757232489798078L;

        public FailedToExecuteRoutingMethodException(String msg, Throwable cause) {
            super(msg, cause);
        }
    }
}

