/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.core.executor.internal;

import com.gigaspaces.annotation.pojo.SpaceRouting;
import com.gigaspaces.executor.SpaceTask;
import com.gigaspaces.executor.SpaceTaskWrapper;
import com.gigaspaces.internal.io.IOUtils;
import com.gigaspaces.internal.version.PlatformLogicalVersion;
import com.gigaspaces.lrmi.LRMIInvocationContext;
import com.gigaspaces.utils.CodeChangeUtilities;
import com.j_spaces.core.IJSpace;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import net.jini.core.transaction.Transaction;
import org.jini.rio.boot.SupportCodeChangeAnnotationContainer;
import org.openspaces.core.executor.Task;
import org.openspaces.core.transaction.manager.ExistingJiniTransactionManager;

public class InternalSpaceTaskWrapper<T extends Serializable>
implements SpaceTask<T>,
SpaceTaskWrapper,
Externalizable {
    private static final long serialVersionUID = -7391977361461247102L;
    private Task<T> task;
    private Object routing;

    public InternalSpaceTaskWrapper() {
    }

    public InternalSpaceTaskWrapper(Task<T> task, Object routing) {
        this();
        this.task = task;
        this.routing = routing;
    }

    public SupportCodeChangeAnnotationContainer getSupportCodeChangeAnnotationContainer() {
        return CodeChangeUtilities.createContainerFromSupportCodeAnnotationIfNeeded(this.task);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T execute(IJSpace space, Transaction tx) throws Exception {
        if (tx != null) {
            try {
                ExistingJiniTransactionManager.bindExistingTransaction(tx);
                T t = this.task.execute();
                return t;
            }
            finally {
                ExistingJiniTransactionManager.unbindExistingTransaction();
            }
        }
        return this.task.execute();
    }

    public Object getWrappedTask() {
        return this.getTask();
    }

    public Task<T> getTask() {
        return this.task;
    }

    @SpaceRouting
    public Object getRouting() {
        return this.routing;
    }

    public void setRouting(Object routing) {
        this.routing = routing;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.task);
        out.writeObject(this.routing);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        boolean supportCodeChange;
        PlatformLogicalVersion version = LRMIInvocationContext.getEndpointLogicalVersion();
        SupportCodeChangeAnnotationContainer supportCodeChangeAnnotationContainer = null;
        if ((version.patchSameOrGreater(PlatformLogicalVersion.v10_2_0_PATCH2) || version.greaterOrEquals(PlatformLogicalVersion.v11_0_0) && version.lessThan(PlatformLogicalVersion.v12_1_0)) && (supportCodeChange = in.readBoolean())) {
            supportCodeChangeAnnotationContainer = SupportCodeChangeAnnotationContainer.ONE_TIME;
        }
        this.task = (Task)IOUtils.readObject((ObjectInput)in, (SupportCodeChangeAnnotationContainer)supportCodeChangeAnnotationContainer, (boolean)false);
        this.routing = in.readObject();
    }
}

