/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.core.executor.juc;

import com.gigaspaces.async.AsyncResult;
import com.gigaspaces.async.AsyncResultFilter;
import com.gigaspaces.async.AsyncResultFilterEvent;
import com.gigaspaces.async.AsyncResultsReducer;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.List;
import java.util.concurrent.Callable;
import org.openspaces.core.executor.DistributedTask;
import org.openspaces.core.executor.juc.CallableTaskAdapter;

public class CallableDistributedTaskAdapter<T extends Serializable, R>
extends CallableTaskAdapter<T>
implements DistributedTask<T, R>,
AsyncResultFilter<T> {
    private static final long serialVersionUID = -5146382658283768618L;
    private transient AsyncResultsReducer<T, R> reducer;
    private transient AsyncResultFilter<T> filter;

    public CallableDistributedTaskAdapter() {
    }

    public CallableDistributedTaskAdapter(Callable<T> callable) throws IllegalArgumentException {
        super(callable);
        if (!(callable instanceof AsyncResultsReducer)) {
            throw new IllegalArgumentException("Callable must either implement the AsyncResultReducer interface, or provide it");
        }
        this.reducer = (AsyncResultsReducer)callable;
        if (callable instanceof AsyncResultFilter) {
            this.filter = (AsyncResultFilter)callable;
        }
    }

    public CallableDistributedTaskAdapter(Callable<T> callable, AsyncResultsReducer<T, R> reducer) throws IllegalArgumentException {
        super(callable);
        this.reducer = reducer;
        if (callable instanceof AsyncResultFilter) {
            this.filter = (AsyncResultFilter)callable;
        }
        if (reducer instanceof AsyncResultFilter) {
            this.filter = (AsyncResultFilter)reducer;
        }
    }

    public CallableDistributedTaskAdapter(Callable<T> callable, AsyncResultsReducer<T, R> reducer, AsyncResultFilter<T> filter) throws IllegalArgumentException {
        super(callable);
        this.reducer = reducer;
        this.filter = filter;
    }

    public R reduce(List<AsyncResult<T>> results) throws Exception {
        return (R)this.reducer.reduce(results);
    }

    public AsyncResultFilter.Decision onResult(AsyncResultFilterEvent<T> event) {
        if (this.filter != null) {
            return this.filter.onResult(event);
        }
        return AsyncResultFilter.Decision.CONTINUE;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
    }
}

