/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.core.executor.juc;

import com.gigaspaces.async.AsyncFuture;
import com.gigaspaces.async.AsyncResultsReducer;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.openspaces.core.GigaSpace;
import org.openspaces.core.executor.juc.CallableDistributedTaskAdapter;
import org.openspaces.core.executor.juc.CallableTaskAdapter;
import org.openspaces.core.executor.juc.RunnableDistributedTaskAdapter;
import org.openspaces.core.executor.juc.RunnableTaskAdapter;
import org.openspaces.core.executor.juc.TaskExecutorService;
import org.openspaces.core.executor.support.WaitForAllListener;
import org.openspaces.core.executor.support.WaitForAnyListener;

public class DefaultTaskExecutorService
implements TaskExecutorService {
    private GigaSpace gigaSpace;
    private volatile boolean shutdown = false;

    public DefaultTaskExecutorService(GigaSpace gigaSpace) {
        this.gigaSpace = gigaSpace;
    }

    @Override
    public void execute(Runnable command) {
        if (command instanceof AsyncResultsReducer) {
            this.gigaSpace.execute(new RunnableDistributedTaskAdapter(command));
        } else {
            this.gigaSpace.execute(new RunnableTaskAdapter(command));
        }
    }

    public <T> AsyncFuture<T> submit(Callable<T> task) {
        Object result = task instanceof AsyncResultsReducer ? this.gigaSpace.execute(new CallableDistributedTaskAdapter(task)) : this.gigaSpace.execute(new CallableTaskAdapter<T>(task));
        return result;
    }

    @Override
    public <T> Future<T> submit(Callable<T> task, Object routing) {
        return this.gigaSpace.execute(new CallableTaskAdapter<T>(task), routing);
    }

    public AsyncFuture<?> submit(Runnable task) {
        Object result = task instanceof AsyncResultsReducer ? this.gigaSpace.execute(new RunnableDistributedTaskAdapter(task)) : this.gigaSpace.execute(new RunnableTaskAdapter(task));
        return result;
    }

    public <T> AsyncFuture<T> submit(Runnable task, T result) {
        Object future = task instanceof AsyncResultsReducer ? this.gigaSpace.execute(new RunnableDistributedTaskAdapter(task, (Serializable)result)) : this.gigaSpace.execute(new RunnableTaskAdapter<Serializable>(task, (Serializable)result));
        return future;
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) throws InterruptedException {
        return this.invokeAll(tasks, -1L, TimeUnit.MILLISECONDS);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException {
        WaitForAllListener listener = new WaitForAllListener(tasks.size());
        ArrayList<void> results = new ArrayList<void>(tasks.size());
        for (Callable<T> task : tasks) {
            void var9_8;
            if (task instanceof AsyncResultsReducer) {
                AsyncFuture asyncFuture = this.gigaSpace.execute(new CallableDistributedTaskAdapter(task));
            } else {
                AsyncFuture<T> asyncFuture = this.gigaSpace.execute(new CallableTaskAdapter<T>(task));
            }
            var9_8.setListener(listener);
            results.add(var9_8);
        }
        Future<T>[] result = listener.waitForResult(timeout, unit);
        for (AsyncFuture asyncFuture : results) {
            if (asyncFuture.isDone()) continue;
            asyncFuture.cancel(false);
        }
        return Arrays.asList(result);
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks) throws InterruptedException, ExecutionException {
        try {
            return this.invokeAny(tasks, -1L, TimeUnit.MILLISECONDS);
        }
        catch (TimeoutException e) {
            throw new ExecutionException("Timeout waiting for result", e);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        WaitForAnyListener listener = new WaitForAnyListener(tasks.size());
        ArrayList<void> results = new ArrayList<void>(tasks.size());
        for (Callable<T> task : tasks) {
            void var9_8;
            if (task instanceof AsyncResultsReducer) {
                AsyncFuture asyncFuture = this.gigaSpace.execute(new CallableDistributedTaskAdapter(task));
            } else {
                AsyncFuture<T> asyncFuture = this.gigaSpace.execute(new CallableTaskAdapter<T>(task));
            }
            var9_8.setListener(listener);
            results.add(var9_8);
        }
        Object result = listener.waitForResult(timeout, unit);
        for (AsyncFuture asyncFuture : results) {
            if (asyncFuture.isDone()) continue;
            asyncFuture.cancel(false);
        }
        return result;
    }

    @Override
    public void shutdown() {
        this.shutdown = true;
    }

    @Override
    public List<Runnable> shutdownNow() {
        this.shutdown = true;
        return new ArrayList<Runnable>();
    }

    @Override
    public boolean isShutdown() {
        return this.shutdown;
    }

    @Override
    public boolean isTerminated() {
        return this.shutdown;
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        return true;
    }
}

