/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.core.executor.juc;

import com.gigaspaces.async.AsyncResult;
import com.gigaspaces.async.AsyncResultFilter;
import com.gigaspaces.async.AsyncResultFilterEvent;
import com.gigaspaces.async.AsyncResultsReducer;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.List;
import org.openspaces.core.executor.DistributedTask;
import org.openspaces.core.executor.juc.RunnableTaskAdapter;

public class RunnableDistributedTaskAdapter<T extends Serializable, R>
extends RunnableTaskAdapter<T>
implements DistributedTask<T, R>,
AsyncResultFilter<T> {
    private static final long serialVersionUID = 8361827094517059908L;
    private transient AsyncResultsReducer<T, R> reducer;
    private transient AsyncResultFilter<T> filter;

    public RunnableDistributedTaskAdapter() {
    }

    public RunnableDistributedTaskAdapter(Runnable runnable) throws IllegalArgumentException {
        super(runnable);
        if (!(runnable instanceof AsyncResultsReducer)) {
            throw new IllegalArgumentException("Runnable must either implement the AsyncResultReducer interface, or provide it");
        }
        this.reducer = (AsyncResultsReducer)runnable;
        if (runnable instanceof AsyncResultFilter) {
            this.filter = (AsyncResultFilter)runnable;
        }
    }

    public RunnableDistributedTaskAdapter(Runnable runnable, T result) {
        super(runnable, result);
        if (!(runnable instanceof AsyncResultsReducer)) {
            throw new IllegalArgumentException("Runnable must either implement the AsyncResultReducer interface, or provide it");
        }
        this.reducer = (AsyncResultsReducer)runnable;
        if (runnable instanceof AsyncResultFilter) {
            this.filter = (AsyncResultFilter)runnable;
        }
    }

    public RunnableDistributedTaskAdapter(Runnable runnable, AsyncResultsReducer<T, R> reducer) throws IllegalArgumentException {
        super(runnable);
        this.reducer = reducer;
        if (runnable instanceof AsyncResultFilter) {
            this.filter = (AsyncResultFilter)runnable;
        }
        if (reducer instanceof AsyncResultFilter) {
            this.filter = (AsyncResultFilter)reducer;
        }
    }

    public RunnableDistributedTaskAdapter(Runnable runnable, T result, AsyncResultsReducer<T, R> reducer) throws IllegalArgumentException {
        super(runnable, result);
        this.reducer = reducer;
        if (runnable instanceof AsyncResultFilter) {
            this.filter = (AsyncResultFilter)runnable;
        }
        if (reducer instanceof AsyncResultFilter) {
            this.filter = (AsyncResultFilter)reducer;
        }
    }

    public RunnableDistributedTaskAdapter(Runnable runnable, AsyncResultsReducer<T, R> reducer, AsyncResultFilter<T> filter) throws IllegalArgumentException {
        super(runnable);
        this.reducer = reducer;
        this.filter = filter;
    }

    public RunnableDistributedTaskAdapter(Runnable runnable, T result, AsyncResultsReducer<T, R> reducer, AsyncResultFilter<T> filter) throws IllegalArgumentException {
        super(runnable, result);
        this.reducer = reducer;
        this.filter = filter;
    }

    public R reduce(List<AsyncResult<T>> results) throws Exception {
        return (R)this.reducer.reduce(results);
    }

    public AsyncResultFilter.Decision onResult(AsyncResultFilterEvent<T> event) {
        if (this.filter != null) {
            return this.filter.onResult(event);
        }
        return AsyncResultFilter.Decision.CONTINUE;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
    }
}

