/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.core.executor.juc;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import org.openspaces.core.executor.Task;
import org.openspaces.core.executor.TaskRoutingProvider;
import org.openspaces.core.executor.support.ProcessObjectsProvider;

public class RunnableTaskAdapter<T extends Serializable>
implements Task<T>,
ProcessObjectsProvider,
TaskRoutingProvider,
Externalizable {
    private static final long serialVersionUID = -5958775825432335114L;
    private Runnable runnable;
    private T result;

    public RunnableTaskAdapter() {
    }

    public RunnableTaskAdapter(Runnable runnable) {
        this.runnable = runnable;
    }

    public RunnableTaskAdapter(Runnable runnable, T result) {
        this.runnable = runnable;
        this.result = result;
    }

    @Override
    public T execute() throws Exception {
        this.runnable.run();
        return this.result;
    }

    @Override
    public Object[] getObjectsToProcess() {
        return new Object[]{this.runnable};
    }

    @Override
    public Object getRouting() {
        return this.runnable;
    }

    protected Runnable getRunnable() {
        return this.runnable;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.runnable);
        if (this.result == null) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            out.writeObject(this.result);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.runnable = (Runnable)in.readObject();
        if (in.readBoolean()) {
            this.result = (Serializable)in.readObject();
        }
    }
}

