/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.core.executor.support;

import com.gigaspaces.async.AsyncResult;
import java.util.List;
import org.openspaces.core.executor.support.NoResultsException;
import org.openspaces.core.executor.support.SumReducer;

public class AvgReducer<T extends Number, R extends Number>
extends SumReducer<T, R> {
    public AvgReducer(Class<R> reduceType) throws IllegalArgumentException {
        super(reduceType);
    }

    @Override
    public AvgReducer ignoreExceptions() {
        super.ignoreExceptions();
        return this;
    }

    @Override
    public R reduce(List<AsyncResult<T>> results) throws Exception {
        Object sum = super.reduce((List)results);
        int count = 0;
        for (AsyncResult<T> result : results) {
            if (result.getException() == null) {
                ++count;
                continue;
            }
            throw result.getException();
        }
        if (count == 0) {
            throw new NoResultsException("No results to calculate average on");
        }
        return (R)this.redeuceHelper.div((Number)sum, count);
    }
}

