/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.core.executor.support;

import com.gigaspaces.async.AsyncResult;
import com.gigaspaces.async.AsyncResultsReducer;
import java.util.List;
import org.openspaces.core.executor.support.NoResultsException;
import org.openspaces.core.util.numbers.NumberHelper;
import org.openspaces.core.util.numbers.NumberHelperFactory;

public class MaxReducer<T extends Number>
implements AsyncResultsReducer<T, T> {
    private volatile boolean ignoreExceptions;
    private NumberHelper<T> reduceHelper;

    public MaxReducer(Class<T> reduceType) throws IllegalArgumentException {
        this.reduceHelper = NumberHelperFactory.getNumberHelper(reduceType);
    }

    public MaxReducer ignoreExceptions() {
        this.ignoreExceptions = true;
        return this;
    }

    public T reduce(List<AsyncResult<T>> results) throws Exception {
        Number candidate = null;
        for (AsyncResult<T> result : results) {
            if (result.getException() != null) {
                if (this.ignoreExceptions) continue;
                throw result.getException();
            }
            if (candidate == null) {
                candidate = (Number)result.getResult();
                continue;
            }
            if (this.reduceHelper.compare(result.getResult(), candidate) <= 0) continue;
            candidate = (Number)result.getResult();
        }
        if (candidate == null) {
            throw new NoResultsException("No results to calculate reduce operations even though ignoring exceptions");
        }
        return (T)candidate;
    }
}

