/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.core.executor.support;

import com.gigaspaces.async.AsyncResult;
import com.gigaspaces.async.AsyncResultFilter;
import com.gigaspaces.async.AsyncResultFilterEvent;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.List;
import org.openspaces.core.executor.DistributedTask;
import org.openspaces.core.executor.support.AbstractDelegatingDistributedTask;

public class PrivilegedDistributedTask<T extends Serializable, R>
extends AbstractDelegatingDistributedTask<T, R>
implements Externalizable {
    private static final long serialVersionUID = 8798827598285224843L;
    private transient T result;
    private transient R reduceResult;
    private transient Exception exception;

    public PrivilegedDistributedTask() {
    }

    public PrivilegedDistributedTask(DistributedTask<T, R> task) {
        super(task);
    }

    public PrivilegedDistributedTask(DistributedTask<T, R> task, AsyncResultFilter<T> filter) {
        super(task, filter);
    }

    @Override
    public T execute() throws Exception {
        AccessControlContext acc = AccessController.getContext();
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                try {
                    PrivilegedDistributedTask.this.result = PrivilegedDistributedTask.this.getDelegatedTask().execute();
                }
                catch (Exception ex) {
                    PrivilegedDistributedTask.this.exception = ex;
                }
                return null;
            }
        }, acc);
        if (this.exception != null) {
            throw this.exception;
        }
        return this.result;
    }

    public R reduce(final List<AsyncResult<T>> results) throws Exception {
        AccessControlContext acc = AccessController.getContext();
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                try {
                    PrivilegedDistributedTask.this.reduceResult = ((DistributedTask)PrivilegedDistributedTask.this.getDelegatedTask()).reduce(results);
                }
                catch (Exception ex) {
                    PrivilegedDistributedTask.this.exception = ex;
                }
                return null;
            }
        }, acc);
        if (this.exception != null) {
            throw this.exception;
        }
        return this.reduceResult;
    }

    @Override
    public AsyncResultFilter.Decision onResult(final AsyncResultFilterEvent<T> event) {
        if (this.getFilter() == null) {
            return AsyncResultFilter.Decision.CONTINUE;
        }
        AccessControlContext acc = AccessController.getContext();
        return AccessController.doPrivileged(new PrivilegedAction<AsyncResultFilter.Decision>(){

            @Override
            public AsyncResultFilter.Decision run() {
                return PrivilegedDistributedTask.this.getFilter().onResult(event);
            }
        }, acc);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super._writeExternal(out);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super._readExternal(in);
    }
}

