/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.core.executor.support;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedAction;
import org.openspaces.core.executor.Task;
import org.openspaces.core.executor.support.SimpleDelegatingTask;

public class PrivilegedTask<T extends Serializable>
extends SimpleDelegatingTask<T>
implements Externalizable {
    private static final long serialVersionUID = 5299631827451867456L;
    private transient T result;
    private transient Exception exception;

    public PrivilegedTask() {
    }

    public PrivilegedTask(Task<T> task) {
        super(task);
    }

    @Override
    public T execute() throws Exception {
        AccessControlContext acc = AccessController.getContext();
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    PrivilegedTask.this.result = PrivilegedTask.this.getDelegatedTask().execute();
                }
                catch (Exception ex) {
                    PrivilegedTask.this.exception = ex;
                }
                return null;
            }
        }, acc);
        if (this.exception != null) {
            throw this.exception;
        }
        return this.result;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super._writeExternal(out);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super._readExternal(in);
    }
}

