/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.core.executor.support;

import com.gigaspaces.async.AsyncResult;
import com.gigaspaces.async.AsyncResultsReducer;
import java.util.List;
import org.openspaces.core.util.numbers.NumberHelper;
import org.openspaces.core.util.numbers.NumberHelperFactory;

public class SumReducer<T extends Number, R extends Number>
implements AsyncResultsReducer<T, R> {
    private volatile boolean ignoreExceptions;
    protected final NumberHelper<R> redeuceHelper;

    public SumReducer(Class<R> reduceType) throws IllegalArgumentException {
        this.redeuceHelper = NumberHelperFactory.getNumberHelper(reduceType);
    }

    public SumReducer ignoreExceptions() {
        this.ignoreExceptions = true;
        return this;
    }

    public R reduce(List<AsyncResult<T>> results) throws Exception {
        R sum = this.redeuceHelper.ZERO();
        for (AsyncResult<T> result : results) {
            if (result.getException() != null) {
                if (this.ignoreExceptions) continue;
                throw result.getException();
            }
            sum = this.redeuceHelper.add((Number)sum, (Number)result.getResult());
        }
        return sum;
    }
}

