/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.core.executor.support;

import com.gigaspaces.async.AsyncFutureListener;
import com.gigaspaces.async.AsyncResult;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.openspaces.core.executor.support.AsyncResultFuture;

public class WaitForAllListener<T>
implements AsyncFutureListener<T> {
    private final ReentrantLock lock = new ReentrantLock();
    private final Condition resultArrived = this.lock.newCondition();
    private int numberOfResults;
    private final AsyncFutureListener<T> listener;
    private final Future<T>[] results;
    private int numberOfResultsArrived;

    public WaitForAllListener(int numberOfResults) {
        this(numberOfResults, null);
    }

    public WaitForAllListener(int numberOfResults, AsyncFutureListener<T> listener) {
        this.listener = listener;
        this.numberOfResults = numberOfResults;
        this.results = new Future[numberOfResults];
    }

    public void onResult(AsyncResult<T> result) {
        if (this.listener != null) {
            this.listener.onResult(result);
        }
        this.lock.lock();
        try {
            this.results[this.numberOfResultsArrived++] = new AsyncResultFuture<T>(result);
            if (this.numberOfResultsArrived == this.numberOfResults) {
                this.resultArrived.signalAll();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public Future<T>[] waitForResult() throws InterruptedException {
        return this.waitForResult(-1L, TimeUnit.MILLISECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Future<T>[] waitForResult(long timeout, TimeUnit unit) throws InterruptedException {
        this.lock.lock();
        try {
            if (this.numberOfResults == this.numberOfResultsArrived) {
                Future<T>[] futureArray = this.results;
                return futureArray;
            }
            if (timeout == -1L) {
                this.resultArrived.await();
            } else {
                this.resultArrived.await(timeout, unit);
            }
            if (this.numberOfResultsArrived == this.numberOfResults) {
                Future<T>[] futureArray = this.results;
                return futureArray;
            }
            Future[] partialResult = new Future[this.numberOfResultsArrived];
            System.arraycopy(this.results, 0, partialResult, 0, this.numberOfResultsArrived);
            Future[] futureArray = partialResult;
            return futureArray;
        }
        finally {
            this.lock.unlock();
        }
    }
}

