/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.core.executor.support;

import com.gigaspaces.async.AsyncFutureListener;
import com.gigaspaces.async.AsyncResult;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;

public class WaitForAnyListener<T>
implements AsyncFutureListener<T> {
    private final ReentrantLock lock = new ReentrantLock();
    private final Condition resultArrived = this.lock.newCondition();
    private final int numberOfResults;
    private int numberOfResultsArrived;
    private T result;
    private final AsyncFutureListener<T> listener;

    public WaitForAnyListener(int numberOfResults) {
        this(numberOfResults, null);
    }

    public WaitForAnyListener(int numberOfResults, AsyncFutureListener<T> listener) {
        this.numberOfResults = numberOfResults;
        this.listener = listener;
    }

    public void onResult(AsyncResult<T> result) {
        if (this.listener != null) {
            this.listener.onResult(result);
        }
        this.lock.lock();
        try {
            if (result.getException() == null) {
                this.result = result.getResult();
                this.resultArrived.signalAll();
            }
            if (++this.numberOfResultsArrived == this.numberOfResults) {
                this.resultArrived.signalAll();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public T waitForResult() throws InterruptedException {
        try {
            return this.waitForResult(-1L, TimeUnit.MILLISECONDS);
        }
        catch (TimeoutException e) {
            throw new RuntimeException("Should not occur as we are waiting forever");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T waitForResult(long timeout, TimeUnit unit) throws InterruptedException, TimeoutException {
        this.lock.lock();
        try {
            if (this.result != null) {
                T t = this.result;
                return t;
            }
            if (timeout == -1L) {
                this.resultArrived.await();
            } else {
                this.resultArrived.await(timeout, unit);
            }
            if (this.result != null) {
                T t = this.result;
                return t;
            }
        }
        finally {
            this.lock.unlock();
        }
        throw new TimeoutException("Timeout waiting for result for [" + timeout + "]");
    }
}

