/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.core.jini;

import com.j_spaces.core.jini.SharedDiscoveryManagement;
import java.lang.reflect.InvocationTargetException;
import net.jini.core.discovery.LookupLocator;
import net.jini.core.entry.Entry;
import net.jini.core.lookup.ServiceItem;
import net.jini.core.lookup.ServiceTemplate;
import net.jini.discovery.LookupGroups;
import net.jini.lookup.entry.Name;
import org.aopalliance.aop.Advice;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.aop.framework.ProxyFactory;
import org.springframework.beans.factory.config.AbstractFactoryBean;

public class JiniServiceFactoryBean
extends AbstractFactoryBean
implements MethodInterceptor {
    private static final Log logger = LogFactory.getLog(JiniServiceFactoryBean.class);
    private ServiceTemplate template;
    private Class<?> serviceClass;
    private String serviceName;
    private String[] groups = LookupGroups.all();
    private String[] locators = null;
    private long timeout = 30000L;
    private volatile Object actualService;
    private final Object actualServiceMonitor = new Object();
    private boolean smartProxy = false;
    private int retryCountOnFailure = 3;

    public Class<?> getObjectType() {
        if (this.actualService == null) {
            if (this.template == null) {
                return this.serviceClass == null ? null : this.serviceClass;
            }
            if (this.template.serviceTypes != null && this.template.serviceTypes.length > 0) {
                return this.template.serviceTypes[0];
            }
        }
        if (this.actualService == null) {
            throw new IllegalArgumentException("Failed to identify factory class type");
        }
        return this.actualService.getClass();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object createInstance() throws Exception {
        Object object = this.actualServiceMonitor;
        synchronized (object) {
            this.actualService = this.lookupService();
        }
        if (!this.smartProxy) {
            return this.actualService;
        }
        ProxyFactory proxyFactory = new ProxyFactory(this.actualService);
        proxyFactory.addAdvice((Advice)this);
        return proxyFactory.getProxy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(MethodInvocation methodInvocation) throws Throwable {
        int retries = this.retryCountOnFailure;
        while (true) {
            try {
                if (this.actualService == null) {
                    Object object = this.actualServiceMonitor;
                    synchronized (object) {
                        if (this.actualService == null) {
                            this.actualService = this.lookupService();
                        }
                    }
                }
                return methodInvocation.getMethod().invoke(this.actualService, methodInvocation.getArguments());
            }
            catch (InvocationTargetException e) {
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)("Failed to execute [" + methodInvocation.getMethod().getName() + "] on [" + this.actualService + "]"), (Throwable)e);
                }
                Object object = this.actualServiceMonitor;
                synchronized (object) {
                    this.actualService = null;
                    continue;
                }
                if (--retries != 0) continue;
                throw e.getTargetException();
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object lookupService() throws Exception {
        ServiceTemplate templ;
        Object service = null;
        if (this.template == null) {
            Entry[] entryArray;
            Class[] classArray;
            if (this.serviceClass == null) {
                classArray = null;
            } else {
                Class[] classArray2 = new Class[1];
                classArray = classArray2;
                classArray2[0] = this.serviceClass;
            }
            Class[] types = classArray;
            if (this.serviceName == null) {
                entryArray = null;
            } else {
                Entry[] entryArray2 = new Entry[1];
                entryArray = entryArray2;
                entryArray2[0] = new Name(this.serviceName);
            }
            Entry[] entry = entryArray;
            templ = new ServiceTemplate(null, types, entry);
        } else {
            templ = this.template;
        }
        LookupLocator[] lookupLocators = null;
        if (this.locators != null) {
            lookupLocators = new LookupLocator[this.locators.length];
            for (int i = 0; i < this.locators.length; ++i) {
                String locator = this.locators[i];
                if (!locator.startsWith("jini://")) {
                    locator = "jini://" + locator;
                }
                lookupLocators[i] = new LookupLocator(locator);
            }
        }
        SharedDiscoveryManagement.SharedServiceDiscoveryManager serviceDiscovery = null;
        try {
            serviceDiscovery = SharedDiscoveryManagement.getBackwardsServiceDiscoveryManager((String[])this.groups, (LookupLocator[])lookupLocators, null);
            ServiceItem returnObject = serviceDiscovery.lookup(templ, null, this.timeout);
            if (returnObject != null) {
                service = returnObject.service;
            }
        }
        finally {
            if (serviceDiscovery != null) {
                try {
                    serviceDiscovery.terminate();
                }
                catch (Exception e) {
                    logger.warn((Object)"Failed to terminate service discovery, ignoring", (Throwable)e);
                }
            }
        }
        return service;
    }

    public void setSmartProxy(boolean smartProxy) {
        this.smartProxy = smartProxy;
    }

    public void setRetryCountOnFailure(int retryCountOnFailure) {
        this.retryCountOnFailure = retryCountOnFailure;
    }

    public String[] getGroups() {
        return this.groups;
    }

    public void setGroups(String[] groups) {
        this.groups = groups;
    }

    public String[] getLocators() {
        return this.locators;
    }

    public void setLocators(String[] locators) {
        this.locators = locators;
    }

    public Class<?> getServiceClass() {
        return this.serviceClass;
    }

    public void setServiceClass(Class<?> serviceClass) {
        this.serviceClass = serviceClass;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public ServiceTemplate getTemplate() {
        return this.template;
    }

    public void setTemplate(ServiceTemplate template) {
        this.template = template;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }
}

