/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.core.properties;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.openspaces.core.properties.SanitizeUtil;

public class BeanLevelProperties
implements Serializable {
    private static final long serialVersionUID = -5373882281270584863L;
    private Properties contextProperties = new Properties();
    private Map<String, Properties> beanProperties = new HashMap<String, Properties>();

    public Properties getContextProperties() {
        return this.contextProperties;
    }

    public void setContextProperties(Properties contextProperties) {
        this.contextProperties = contextProperties;
    }

    public Properties getBeanProperties(String beanName) {
        Properties props = this.beanProperties.get(beanName);
        if (props == null) {
            props = new Properties();
            this.beanProperties.put(beanName, props);
        }
        return props;
    }

    public void setBeanProperties(String beanName, Properties nameBasedProperties) {
        this.beanProperties.put(beanName, nameBasedProperties);
    }

    public boolean hasBeanProperties(String beanName) {
        return this.getBeanProperties(beanName).size() != 0;
    }

    public Properties getMergedBeanProperties(String beanName) {
        Properties props = new Properties();
        props.putAll((Map<?, ?>)this.contextProperties);
        Properties nameBasedProperties = this.getBeanProperties(beanName);
        if (nameBasedProperties != null) {
            props.putAll((Map<?, ?>)nameBasedProperties);
        }
        return props;
    }

    public Map<String, Properties> getBeans() {
        return Collections.synchronizedMap(this.beanProperties);
    }

    public String toString() {
        return "Context " + SanitizeUtil.sanitize(this.contextProperties, "password", "EncryptionKey") + " Beans " + SanitizeUtil.sanitize(this.beanProperties, "password", "EncryptionKey");
    }
}

