/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.core.properties;

import java.lang.reflect.Field;
import org.openspaces.core.properties.BeanLevelMergedPropertiesAware;
import org.openspaces.core.properties.BeanLevelMergedPropertiesContext;
import org.openspaces.core.properties.BeanLevelProperties;
import org.openspaces.core.properties.BeanLevelPropertiesAware;
import org.openspaces.core.properties.BeanLevelPropertiesContext;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.util.ReflectionUtils;

public class BeanLevelPropertyBeanPostProcessor
implements BeanPostProcessor {
    private BeanLevelProperties beanLevelProperties;

    public BeanLevelPropertyBeanPostProcessor(BeanLevelProperties beanLevelProperties) {
        this.beanLevelProperties = beanLevelProperties;
    }

    public Object postProcessBeforeInitialization(final Object bean, final String beanName) throws BeansException {
        if (bean instanceof BeanLevelMergedPropertiesAware) {
            ((BeanLevelMergedPropertiesAware)bean).setMergedBeanLevelProperties(this.beanLevelProperties.getMergedBeanProperties(beanName));
        }
        if (bean instanceof BeanLevelPropertiesAware) {
            ((BeanLevelPropertiesAware)bean).setBeanLevelProperties(this.beanLevelProperties);
        }
        if (bean == null) {
            return null;
        }
        ReflectionUtils.doWithFields(bean.getClass(), (ReflectionUtils.FieldCallback)new ReflectionUtils.FieldCallback(){

            public void doWith(Field field) {
                if (field.isAnnotationPresent(BeanLevelMergedPropertiesContext.class)) {
                    if (!field.isAccessible()) {
                        field.setAccessible(true);
                    }
                    try {
                        field.set(bean, BeanLevelPropertyBeanPostProcessor.this.beanLevelProperties.getMergedBeanProperties(beanName));
                    }
                    catch (Exception e) {
                        throw new IllegalArgumentException("Failed to inject Properties (Bean-Level Merged Properties)", e);
                    }
                }
                if (field.isAnnotationPresent(BeanLevelPropertiesContext.class)) {
                    if (!field.isAccessible()) {
                        field.setAccessible(true);
                    }
                    try {
                        field.set(bean, BeanLevelPropertyBeanPostProcessor.this.beanLevelProperties);
                    }
                    catch (Exception e) {
                        throw new IllegalArgumentException("Failed to inject BeanLevelProperties", e);
                    }
                }
            }
        });
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }
}

