/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.core.properties;

import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import org.openspaces.core.cluster.ClusterInfo;
import org.openspaces.core.cluster.ClusterInfoAware;
import org.openspaces.core.cluster.ClusterInfoPropertyPlaceholderConfigurer;
import org.openspaces.core.properties.BeanLevelProperties;
import org.openspaces.core.properties.BeanLevelPropertiesAware;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanDefinitionStoreException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionVisitor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.PropertyPlaceholderConfigurer;

public class BeanLevelPropertyPlaceholderConfigurer
extends PropertyPlaceholderConfigurer
implements BeanNameAware,
BeanFactoryAware,
BeanLevelPropertiesAware,
ClusterInfoAware {
    private BeanLevelProperties beanLevelProperties;
    private ClusterInfo clusterInfo;
    private String beanName;
    private BeanFactory beanFactory;

    public BeanLevelPropertyPlaceholderConfigurer(BeanLevelProperties beanLevelProperties) {
        this.init(beanLevelProperties);
    }

    public BeanLevelPropertyPlaceholderConfigurer(BeanLevelProperties beanLevelProperties, ClusterInfo clusterInfo) {
        this.init(beanLevelProperties);
        this.clusterInfo = clusterInfo;
    }

    @Override
    public void setBeanLevelProperties(BeanLevelProperties beanLevelProperties) {
        this.init(beanLevelProperties);
    }

    @Override
    public void setClusterInfo(ClusterInfo clusterInfo) {
        this.clusterInfo = clusterInfo;
    }

    private void init(BeanLevelProperties beanLevelProperties) {
        this.beanLevelProperties = beanLevelProperties;
        this.setIgnoreUnresolvablePlaceholders(true);
        this.setSystemPropertiesMode(0);
        this.setOrder(2);
    }

    public void setBeanName(String beanName) {
        this.beanName = beanName;
    }

    public void setBeanFactory(BeanFactory beanFactory) {
        this.beanFactory = beanFactory;
    }

    protected void processProperties(ConfigurableListableBeanFactory beanFactoryToProcess, Properties props) throws BeansException {
        String[] beanNames;
        for (String beanName1 : beanNames = beanFactoryToProcess.getBeanDefinitionNames()) {
            if (beanName1.equals(this.beanName) && beanFactoryToProcess.equals(this.beanFactory)) continue;
            Properties beanLevelProps = this.beanLevelProperties.getMergedBeanProperties(beanName1);
            beanLevelProps.putAll((Map<?, ?>)ClusterInfoPropertyPlaceholderConfigurer.createProperties(this.clusterInfo));
            PlaceholderResolvingBeanDefinitionVisitor visitor = new PlaceholderResolvingBeanDefinitionVisitor(beanLevelProps);
            BeanDefinition bd = beanFactoryToProcess.getBeanDefinition(beanName1);
            try {
                visitor.visitBeanDefinition(bd);
            }
            catch (BeanDefinitionStoreException ex) {
                throw new BeanDefinitionStoreException(bd.getResourceDescription(), beanName1, ex.getMessage());
            }
        }
    }

    private class PlaceholderResolvingBeanDefinitionVisitor
    extends BeanDefinitionVisitor {
        private final Properties props;

        public PlaceholderResolvingBeanDefinitionVisitor(Properties props) {
            this.props = props;
        }

        protected String resolveStringValue(String strVal) throws BeansException {
            return BeanLevelPropertyPlaceholderConfigurer.this.parseStringValue(strVal, this.props, new HashSet());
        }
    }
}

