/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.core.properties;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class SanitizeUtil {
    public static Properties sanitize(Properties properties, String ... keywords) {
        if (properties == null) {
            return null;
        }
        Properties res = new Properties();
        for (String key : properties.stringPropertyNames()) {
            if (SanitizeUtil.contains(key, keywords)) {
                res.setProperty(key, "***");
                continue;
            }
            res.setProperty(key, properties.getProperty(key));
        }
        return res;
    }

    public static Map<String, Properties> sanitize(Map<String, Properties> map, String ... keywords) {
        HashMap<String, Properties> res = new HashMap<String, Properties>();
        for (String key : map.keySet()) {
            res.put(key, SanitizeUtil.sanitize(map.get(key), keywords));
        }
        return res;
    }

    private static boolean contains(String key, String[] keywords) {
        for (String keyword : keywords) {
            if (!key.toLowerCase().contains(keyword.toLowerCase())) continue;
            return true;
        }
        return false;
    }
}

