/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.core.space;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Hashtable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AbstractAnnotationRegistry {
    private Hashtable<Class<?>, HashSet<RegistryEntry>> registry = new Hashtable();
    private Log logger = LogFactory.getLog(this.getClass());

    public void registerAnnotation(Class<?> annotation, Object object, Method method) throws IllegalArgumentException {
        if (annotation == null || object == null || method == null) {
            throw new IllegalArgumentException("Illegal null argument in parameter: " + annotation == null ? "annotation" : (object == null ? "object" : "method"));
        }
        this.validateMethod(annotation, method);
        this.storeMethod(annotation, object, method);
    }

    protected abstract void validateMethod(Class<?> var1, Method var2);

    protected void fireEvent(Class<?> annotationClass, Object event) {
        HashSet<RegistryEntry> entries = this.registry.get(annotationClass);
        if (entries != null) {
            for (RegistryEntry registryEntry : entries) {
                try {
                    if (registryEntry.method.getParameterTypes().length == 0) {
                        registryEntry.method.invoke(registryEntry.object, new Object[0]);
                        continue;
                    }
                    registryEntry.method.invoke(registryEntry.object, event);
                }
                catch (InvocationTargetException e) {
                    this.logger.error((Object)("Target invocation method threw an exception. Bean: " + registryEntry.object + ", Method: " + registryEntry.method), (Throwable)e);
                }
                catch (Exception e) {
                    this.logger.error((Object)("Failed to invoke target invocation method. Bean: " + registryEntry.object + ", Method: " + registryEntry.method), (Throwable)e);
                }
            }
        }
    }

    private void storeMethod(Class<?> annotation, Object object, Method method) {
        HashSet<RegistryEntry> methods = this.registry.get(annotation);
        if (methods == null) {
            methods = new HashSet();
            this.registry.put(annotation, methods);
        }
        RegistryEntry entry = new RegistryEntry(object, method);
        methods.add(entry);
    }

    private static class RegistryEntry {
        Object object;
        Method method;

        public RegistryEntry(Object object, Method method) {
            this.object = object;
            this.method = method;
        }

        public boolean equals(Object o) {
            if (o != null && o instanceof RegistryEntry) {
                RegistryEntry entry = (RegistryEntry)o;
                if (entry.object == this.object && entry.method.equals(this.method)) {
                    return true;
                }
            }
            return false;
        }

        public int hashCode() {
            int hash = 1;
            hash = hash * 31 + this.object.hashCode();
            hash = hash * 31 + this.method.hashCode();
            return hash;
        }
    }
}

