/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.core.space;

import com.gigaspaces.cluster.activeelection.ISpaceModeListener;
import com.gigaspaces.cluster.activeelection.SpaceInitializationIndicator;
import com.gigaspaces.cluster.activeelection.SpaceMode;
import com.gigaspaces.internal.client.spaceproxy.ISpaceProxy;
import com.gigaspaces.internal.dump.InternalDump;
import com.gigaspaces.internal.dump.InternalDumpProcessor;
import com.gigaspaces.internal.dump.InternalDumpProcessorFailedException;
import com.gigaspaces.internal.server.space.suspend.SuspendTypeChangedInternalListener;
import com.gigaspaces.security.directory.CredentialsProvider;
import com.gigaspaces.security.directory.DefaultCredentialsProvider;
import com.gigaspaces.security.directory.UserDetails;
import com.gigaspaces.server.space.suspend.SuspendType;
import com.j_spaces.core.IJSpace;
import com.j_spaces.core.admin.IInternalRemoteJSpaceAdmin;
import com.j_spaces.core.admin.SpaceRuntimeInfo;
import java.io.PrintWriter;
import java.rmi.RemoteException;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openspaces.core.cluster.MemberAliveIndicator;
import org.openspaces.core.cluster.SpaceMemberAliveIndicator;
import org.openspaces.core.space.CannotCloseSpaceException;
import org.openspaces.core.space.CannotCreateSpaceException;
import org.openspaces.core.space.SecurityConfig;
import org.openspaces.core.space.SpaceServiceDetails;
import org.openspaces.core.space.mode.AfterSpaceModeChangeEvent;
import org.openspaces.core.space.mode.BeforeSpaceModeChangeEvent;
import org.openspaces.core.space.mode.SpaceAfterBackupListener;
import org.openspaces.core.space.mode.SpaceAfterPrimaryListener;
import org.openspaces.core.space.mode.SpaceBeforeBackupListener;
import org.openspaces.core.space.mode.SpaceBeforePrimaryListener;
import org.openspaces.core.space.status.SpaceStatusChangedEvent;
import org.openspaces.core.space.status.SpaceStatusChangedEventListener;
import org.openspaces.core.util.SpaceUtils;
import org.openspaces.pu.service.ServiceDetails;
import org.openspaces.pu.service.ServiceDetailsProvider;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.dao.DataAccessException;

public abstract class AbstractSpaceFactoryBean
implements BeanNameAware,
InitializingBean,
DisposableBean,
FactoryBean,
ApplicationContextAware,
ApplicationListener,
MemberAliveIndicator,
ServiceDetailsProvider,
InternalDumpProcessor {
    protected Log logger = LogFactory.getLog(this.getClass());
    private String beanName;
    private ISpaceProxy space;
    private ApplicationContext applicationContext;
    private SpaceMode currentSpaceMode;
    private SuspendType currentSuspendType;
    private PrimaryBackupListener appContextPrimaryBackupListener;
    private SuspendTypeChangedInternalListener suspendTypeInternalListener;
    private ISpaceModeListener primaryBackupListener;
    private Boolean registerForSpaceMode;
    private Boolean enableMemberAliveIndicator;
    private MemberAliveIndicator memberAliveIndicator;
    private SecurityConfig securityConfig;

    public void setRegisterForSpaceModeNotifications(boolean registerForSpaceMode) {
        this.registerForSpaceMode = registerForSpaceMode;
    }

    public void setUserDetails(UserDetails userDetails) {
        this.setCredentialsProvider((CredentialsProvider)new DefaultCredentialsProvider(userDetails));
    }

    public void setCredentialsProvider(CredentialsProvider credentialsProvider) {
        this.setSecurityConfig(new SecurityConfig(credentialsProvider));
    }

    public void setSecurityConfig(SecurityConfig securityConfig) {
        this.securityConfig = securityConfig;
    }

    protected SecurityConfig getSecurityConfig() {
        return this.securityConfig;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    protected ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    public void setBeanName(String name) {
        this.beanName = name;
    }

    public void setPrimaryBackupListener(ISpaceModeListener primaryBackupListener) {
        this.primaryBackupListener = primaryBackupListener;
    }

    public void setEnableMemberAliveIndicator(Boolean enableMemberAliveIndicator) {
        this.enableMemberAliveIndicator = enableMemberAliveIndicator;
    }

    /*
     * Unable to fully structure code
     */
    public synchronized void afterPropertiesSet() throws DataAccessException {
        this.space = (ISpaceProxy)this.doCreateSpace();
        adminLazyGetter = new AdminLazyGetter(this.space);
        if (this.isRegisterForSpaceModeNotifications()) {
            try {
                this.appContextPrimaryBackupListener = new PrimaryBackupListener();
                admin = (IInternalRemoteJSpaceAdmin)adminLazyGetter.getAdmin();
                this.currentSpaceMode = admin.addSpaceModeListener((ISpaceModeListener)this.appContextPrimaryBackupListener);
                if (!this.logger.isDebugEnabled()) ** GOTO lbl14
                this.logger.debug((Object)("Space [" + adminLazyGetter.getClusterMemberSpace() + "] mode is [" + this.currentSpaceMode + "]"));
            }
            catch (RemoteException e) {
                throw new CannotCreateSpaceException(MessageFormat.format("Failed to register space mode listener with space [{0}]", new Object[]{this.space}), e);
            }
        } else {
            this.currentSpaceMode = SpaceMode.PRIMARY;
        }
lbl14:
        // 3 sources

        if (this.isEmbedded()) {
            try {
                this.suspendTypeInternalListener = new SuspendTypeChangedInternalListenerImpl();
                admin = (IInternalRemoteJSpaceAdmin)adminLazyGetter.getAdmin();
                this.currentSuspendType = admin.addSpaceSuspendTypeListener(this.suspendTypeInternalListener);
            }
            catch (RemoteException e) {
                throw new CannotCreateSpaceException(MessageFormat.format("Failed to register space suspend type listener with space [{0}]", new Object[]{this.space}), e);
            }
        }
        this.memberAliveIndicator = new SpaceMemberAliveIndicator((IJSpace)this.space, this.enableMemberAliveIndicator);
    }

    public void destroy() throws Exception {
        this.close();
    }

    public synchronized void close() {
        IInternalRemoteJSpaceAdmin admin;
        if (this.space == null) {
            return;
        }
        boolean isEmbedded = this.isEmbedded();
        AdminLazyGetter adminLazyGetter = new AdminLazyGetter(this.space);
        if (this.appContextPrimaryBackupListener != null && this.isRegisterForSpaceModeNotifications()) {
            try {
                admin = (IInternalRemoteJSpaceAdmin)adminLazyGetter.getAdmin();
                admin.removeSpaceModeListener((ISpaceModeListener)this.appContextPrimaryBackupListener);
            }
            catch (RemoteException e) {
                this.logger.warn((Object)("Failed to unregister space mode listener with space [" + this.space + "]"), (Throwable)e);
            }
        }
        if (this.suspendTypeInternalListener != null && isEmbedded) {
            try {
                admin = (IInternalRemoteJSpaceAdmin)adminLazyGetter.getAdmin();
                admin.removeSpaceSuspendTypeListener(this.suspendTypeInternalListener);
            }
            catch (RemoteException e) {
                this.logger.warn((Object)("Failed to unregister space suspend type listener with space [" + this.space + "]"), (Throwable)e);
            }
        }
        try {
            if (isEmbedded) {
                this.space.getDirectProxy().shutdown();
            }
            this.space.close();
        }
        catch (RemoteException e) {
            throw new CannotCloseSpaceException("Failed to close space", e);
        }
        finally {
            this.space = null;
        }
    }

    public void onApplicationEvent(ApplicationEvent applicationEvent) {
        if (applicationEvent instanceof ContextRefreshedEvent && this.applicationContext != null) {
            SpaceInitializationIndicator.setInitializer();
            try {
                this.applicationContext.publishEvent((ApplicationEvent)new BeforeSpaceModeChangeEvent((IJSpace)this.space, this.currentSpaceMode));
                this.applicationContext.publishEvent((ApplicationEvent)new AfterSpaceModeChangeEvent((IJSpace)this.space, this.currentSpaceMode));
                if (this.currentSpaceMode == SpaceMode.BACKUP) {
                    this.fireSpaceBeforeBackupEvent();
                    this.fireSpaceAfterBackupEvent();
                } else if (this.currentSpaceMode == SpaceMode.PRIMARY) {
                    this.fireSpaceBeforePrimaryEvent();
                    this.fireSpaceAfterPrimaryEvent();
                }
                this.fireSpaceStatusChangedEvent();
            }
            finally {
                SpaceInitializationIndicator.unsetInitializer();
            }
        }
    }

    public Object getObject() {
        return this.space;
    }

    public Class<? extends IJSpace> getObjectType() {
        return this.space == null ? IJSpace.class : this.space.getClass();
    }

    public boolean isSingleton() {
        return true;
    }

    @Override
    public boolean isMemberAliveEnabled() {
        return this.memberAliveIndicator.isMemberAliveEnabled();
    }

    @Override
    public boolean isAlive() throws Exception {
        return this.memberAliveIndicator.isAlive();
    }

    protected abstract IJSpace doCreateSpace() throws DataAccessException;

    protected boolean isRegisterForSpaceModeNotifications() {
        if (this.registerForSpaceMode != null) {
            return this.registerForSpaceMode;
        }
        return this.isEmbedded();
    }

    private boolean isEmbedded() {
        return !SpaceUtils.isRemoteProtocol((IJSpace)this.space);
    }

    protected void fireSpaceBeforeBackupEvent() {
        if (this.applicationContext != null) {
            Map beans = this.applicationContext.getBeansOfType(SpaceBeforeBackupListener.class);
            for (SpaceBeforeBackupListener listener : beans.values()) {
                listener.onBeforeBackup(new BeforeSpaceModeChangeEvent((IJSpace)this.space, SpaceMode.BACKUP));
            }
        }
    }

    protected void fireSpaceAfterBackupEvent() {
        if (this.applicationContext != null) {
            Map beans = this.applicationContext.getBeansOfType(SpaceAfterBackupListener.class);
            for (SpaceAfterBackupListener listener : beans.values()) {
                listener.onAfterBackup(new AfterSpaceModeChangeEvent((IJSpace)this.space, SpaceMode.BACKUP));
            }
        }
    }

    protected void fireSpaceBeforePrimaryEvent() {
        if (this.applicationContext != null) {
            Map beans = this.applicationContext.getBeansOfType(SpaceBeforePrimaryListener.class);
            for (SpaceBeforePrimaryListener listener : beans.values()) {
                listener.onBeforePrimary(new BeforeSpaceModeChangeEvent((IJSpace)this.space, SpaceMode.PRIMARY));
            }
        }
    }

    protected void fireSpaceAfterPrimaryEvent() {
        if (this.applicationContext != null) {
            Map beans = this.applicationContext.getBeansOfType(SpaceAfterPrimaryListener.class);
            for (SpaceAfterPrimaryListener listener : beans.values()) {
                listener.onAfterPrimary(new AfterSpaceModeChangeEvent((IJSpace)this.space, SpaceMode.PRIMARY));
            }
        }
    }

    @Override
    public ServiceDetails[] getServicesDetails() {
        return new ServiceDetails[]{new SpaceServiceDetails(this.beanName, (IJSpace)this.space)};
    }

    public String getName() {
        return this.beanName;
    }

    public void process(InternalDump dump) throws InternalDumpProcessorFailedException {
        if (SpaceUtils.isRemoteProtocol((IJSpace)this.space)) {
            return;
        }
        dump.addPrefix("spaces/" + this.beanName + "/");
        try {
            IJSpace clusterMemberSpace = SpaceUtils.getClusterMemberSpace((IJSpace)this.space);
            PrintWriter writer = new PrintWriter(dump.createFileWriter("summary.txt"));
            writer.println("===== URL =====");
            writer.println(clusterMemberSpace.getFinderURL());
            writer.println();
            writer.println("===== RUNTIME INFO =====");
            IInternalRemoteJSpaceAdmin admin = (IInternalRemoteJSpaceAdmin)clusterMemberSpace.getAdmin();
            SpaceRuntimeInfo runtimeInfo = admin.getRuntimeInfo();
            for (int i = 0; i < runtimeInfo.m_ClassNames.size(); ++i) {
                writer.println("Class [" + (String)runtimeInfo.m_ClassNames.get(i) + "], Entries [" + runtimeInfo.m_NumOFEntries.get(i) + "], Templates [" + runtimeInfo.m_NumOFTemplates.get(i) + "]");
            }
            writer.println();
            writer.println("===== REPLICATION INFO =====");
            writer.println(admin.getReplicationDump());
            writer.println();
            writer.close();
        }
        catch (Exception e) {
            throw new InternalDumpProcessorFailedException(this.getName(), "Failed to generate space dump", (Throwable)e);
        }
        finally {
            dump.removePrefix();
        }
    }

    private void fireSpaceStatusChangedEvent() {
        if (this.applicationContext != null) {
            Collection listeners = this.applicationContext.getBeansOfType(SpaceStatusChangedEventListener.class).values();
            for (SpaceStatusChangedEventListener listener : listeners) {
                SpaceStatusChangedEvent event = new SpaceStatusChangedEvent((IJSpace)this.space, this.currentSuspendType, this.currentSpaceMode);
                try {
                    listener.onSpaceStatusChanged(event);
                }
                catch (Exception e) {
                    this.logger.warn((Object)("Failed to dispatch SpaceStatusChangedEvent to listener [" + listener + "]: " + e.getMessage()), (Throwable)e);
                }
            }
        }
    }

    private class AdminLazyGetter {
        private ISpaceProxy space;
        private IJSpace clusterMemberSpace;
        private Object admin;

        public AdminLazyGetter(ISpaceProxy space) {
            this.space = space;
        }

        public Object getAdmin() throws RemoteException {
            if (this.clusterMemberSpace == null) {
                this.clusterMemberSpace = SpaceUtils.getClusterMemberSpace((IJSpace)this.space);
            }
            if (this.admin == null) {
                this.admin = this.clusterMemberSpace.getAdmin();
            }
            return this.admin;
        }

        public IJSpace getClusterMemberSpace() {
            if (this.clusterMemberSpace == null) {
                this.clusterMemberSpace = SpaceUtils.getClusterMemberSpace((IJSpace)this.space);
            }
            return this.clusterMemberSpace;
        }
    }

    private class SuspendTypeChangedInternalListenerImpl
    implements SuspendTypeChangedInternalListener {
        private SuspendTypeChangedInternalListenerImpl() {
        }

        public void onSuspendTypeChanged(SuspendType suspendType) {
            AbstractSpaceFactoryBean.this.currentSuspendType = suspendType;
            AbstractSpaceFactoryBean.this.fireSpaceStatusChangedEvent();
        }
    }

    private class PrimaryBackupListener
    implements ISpaceModeListener {
        private PrimaryBackupListener() {
        }

        public void beforeSpaceModeChange(SpaceMode spaceMode) throws RemoteException {
            AbstractSpaceFactoryBean.this.currentSpaceMode = spaceMode;
            if (AbstractSpaceFactoryBean.this.logger.isDebugEnabled()) {
                AbstractSpaceFactoryBean.this.logger.debug((Object)("Space [" + AbstractSpaceFactoryBean.this.space + "] BEFORE mode is [" + AbstractSpaceFactoryBean.this.currentSpaceMode + "]"));
            }
            if (AbstractSpaceFactoryBean.this.applicationContext != null) {
                AbstractSpaceFactoryBean.this.applicationContext.publishEvent((ApplicationEvent)new BeforeSpaceModeChangeEvent((IJSpace)AbstractSpaceFactoryBean.this.space, spaceMode));
                if (spaceMode == SpaceMode.BACKUP) {
                    AbstractSpaceFactoryBean.this.fireSpaceBeforeBackupEvent();
                } else if (spaceMode == SpaceMode.PRIMARY) {
                    AbstractSpaceFactoryBean.this.fireSpaceBeforePrimaryEvent();
                }
            }
            if (AbstractSpaceFactoryBean.this.primaryBackupListener != null) {
                AbstractSpaceFactoryBean.this.primaryBackupListener.beforeSpaceModeChange(spaceMode);
            }
        }

        public void afterSpaceModeChange(SpaceMode spaceMode) throws RemoteException {
            AbstractSpaceFactoryBean.this.currentSpaceMode = spaceMode;
            if (AbstractSpaceFactoryBean.this.logger.isDebugEnabled()) {
                AbstractSpaceFactoryBean.this.logger.debug((Object)("Space [" + AbstractSpaceFactoryBean.this.space + "] AFTER mode is [" + AbstractSpaceFactoryBean.this.currentSpaceMode + "]"));
            }
            if (AbstractSpaceFactoryBean.this.applicationContext != null) {
                AbstractSpaceFactoryBean.this.applicationContext.publishEvent((ApplicationEvent)new AfterSpaceModeChangeEvent((IJSpace)AbstractSpaceFactoryBean.this.space, spaceMode));
                if (spaceMode == SpaceMode.BACKUP) {
                    AbstractSpaceFactoryBean.this.fireSpaceAfterBackupEvent();
                } else if (spaceMode == SpaceMode.PRIMARY) {
                    AbstractSpaceFactoryBean.this.fireSpaceAfterPrimaryEvent();
                }
            }
            if (AbstractSpaceFactoryBean.this.primaryBackupListener != null) {
                AbstractSpaceFactoryBean.this.primaryBackupListener.afterSpaceModeChange(spaceMode);
            }
            AbstractSpaceFactoryBean.this.fireSpaceStatusChangedEvent();
        }
    }
}

