/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.core.space;

import com.gigaspaces.server.blobstore.BlobStoreException;
import com.gigaspaces.server.blobstore.BlobStoreStorageHandler;
import com.j_spaces.core.client.SQLQuery;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.logging.Logger;
import org.openspaces.core.space.CachePolicy;

public class BlobStoreDataCachePolicy
implements CachePolicy {
    private static final Logger _logger = Logger.getLogger("com.gigaspaces.core.config");
    private Integer avgObjectSizeBytes;
    private Integer cacheEntriesPercentage;
    private Boolean persistent;
    private List<SQLQuery> sqlQueryList = new ArrayList<SQLQuery>();
    private BlobStoreStorageHandler blobStoreHandler;
    private static final int DEFAULT_AVG_OBJECT_SIZE_BYTES = 5120;
    private static final int DEFAULT_CACHE_ENTRIES_PERCENTAGE = 20;

    public BlobStoreDataCachePolicy setBlobStoreHandler(BlobStoreStorageHandler blobStoreHandler) {
        this.blobStoreHandler = blobStoreHandler;
        return this;
    }

    public BlobStoreDataCachePolicy setAvgObjectSizeKB(Integer avgObjectSizeKB) {
        this.avgObjectSizeBytes = avgObjectSizeKB * 1024;
        return this;
    }

    public BlobStoreDataCachePolicy setAvgObjectSizeBytes(Integer avgObjectSizeBytes) {
        this.avgObjectSizeBytes = avgObjectSizeBytes;
        return this;
    }

    public BlobStoreDataCachePolicy setCacheEntriesPercentage(Integer cacheEntriesPercentage) {
        this.cacheEntriesPercentage = cacheEntriesPercentage;
        return this;
    }

    public BlobStoreDataCachePolicy setPersistent(Boolean persistent) {
        this.persistent = persistent;
        return this;
    }

    public BlobStoreDataCachePolicy addCacheQuery(SQLQuery sqlQuery) {
        this.sqlQueryList.add(sqlQuery);
        return this;
    }

    @Override
    public Properties toProps() {
        long blobStoreCacheSize;
        Properties props = new Properties();
        props.setProperty("space-config.engine.cache_policy", "3");
        if (this.cacheEntriesPercentage == null) {
            this.cacheEntriesPercentage = 20;
        }
        if (this.avgObjectSizeBytes == null) {
            this.avgObjectSizeBytes = 5120;
        }
        this.assertPropPositive("cacheEntriesPercentage", this.cacheEntriesPercentage.intValue());
        this.assertPropPositive("avgObjectSizeBytes", this.avgObjectSizeBytes.intValue());
        this.assertPropNotZero("avgObjectSizeBytes", this.avgObjectSizeBytes.intValue());
        if (this.cacheEntriesPercentage != 0) {
            long maxMemoryInBytes = Runtime.getRuntime().maxMemory();
            if (maxMemoryInBytes == Long.MAX_VALUE) {
                blobStoreCacheSize = Long.parseLong("10000");
                _logger.fine("Blob Store Cache size [ " + blobStoreCacheSize + " ]");
            } else {
                double percentage = (double)this.cacheEntriesPercentage.intValue() / 100.0;
                blobStoreCacheSize = (long)((double)maxMemoryInBytes * percentage / (double)this.avgObjectSizeBytes.intValue());
            }
        } else {
            blobStoreCacheSize = 0L;
        }
        props.setProperty("space-config.engine.blobstore_cache_size", String.valueOf(blobStoreCacheSize));
        _logger.info("Blob Store Cache size [ " + blobStoreCacheSize + " ]");
        if (this.persistent == null) {
            throw new BlobStoreException("persistent attribute in Blobstore space must be configured");
        }
        props.put("space-config.engine.blobstore_persistent", String.valueOf(this.persistent));
        if (this.blobStoreHandler == null) {
            throw new BlobStoreException("blobStoreHandler attribute in Blobstore space must be configured");
        }
        props.put("engine.blobstore_storage_handler_instance", this.blobStoreHandler);
        if (this.sqlQueryList.size() > 0) {
            props.put("space-config.engine.blobstore_cache_filter_queries", this.sqlQueryList);
        }
        return props;
    }

    private void assertPropPositive(String propName, long propValue) {
        if (propValue < 0L) {
            throw new IllegalArgumentException(propName + " can not be negative");
        }
    }

    private void assertPropNotZero(String propName, long propValue) {
        if (propValue == 0L) {
            throw new IllegalArgumentException(propName + " can not be zero");
        }
    }
}

