/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.core.space;

import com.gigaspaces.attribute_store.AttributeStore;
import com.gigaspaces.cluster.activeelection.ISpaceModeListener;
import com.gigaspaces.datasource.ManagedDataSource;
import com.gigaspaces.datasource.SpaceDataSource;
import com.gigaspaces.metadata.SpaceTypeDescriptor;
import com.gigaspaces.query.extension.QueryExtensionProvider;
import com.gigaspaces.security.directory.CredentialsProvider;
import com.gigaspaces.security.directory.DefaultCredentialsProvider;
import com.gigaspaces.sync.SpaceSynchronizationEndpoint;
import com.j_spaces.core.IJSpace;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.openspaces.core.cluster.ClusterInfo;
import org.openspaces.core.config.BlobStoreDataPolicyConfigurer;
import org.openspaces.core.config.BlobStoreDataPolicyFactoryBean;
import org.openspaces.core.config.CustomCachePolicyFactoryBean;
import org.openspaces.core.extension.SpaceCustomComponentFactoryBean;
import org.openspaces.core.space.AbstractSpaceConfigurer;
import org.openspaces.core.space.CachePolicy;
import org.openspaces.core.space.EmbeddedSpaceFactoryBean;
import org.openspaces.core.space.filter.FilterProviderFactory;
import org.openspaces.core.space.filter.replication.ReplicationFilterProviderFactory;
import org.openspaces.core.transaction.DistributedTransactionProcessingConfigurationFactoryBean;
import org.springframework.util.StringUtils;

public class EmbeddedSpaceConfigurer
extends AbstractSpaceConfigurer {
    private final EmbeddedSpaceFactoryBean factoryBean;
    private final Properties properties = new Properties();
    private final List<FilterProviderFactory> filterProviderFactories = new ArrayList<FilterProviderFactory>();
    private final List<SpaceTypeDescriptor> typeDescriptors = new ArrayList<SpaceTypeDescriptor>();
    private final List<QueryExtensionProvider> queryExtensionProviders = new ArrayList<QueryExtensionProvider>();

    public EmbeddedSpaceConfigurer(String name) {
        this.factoryBean = new EmbeddedSpaceFactoryBean(name);
    }

    @Override
    public void close() {
        this.factoryBean.close();
    }

    @Override
    protected IJSpace createSpace() {
        this.factoryBean.setProperties(this.properties);
        this.factoryBean.setFilterProviders(this.filterProviderFactories.toArray(new FilterProviderFactory[this.filterProviderFactories.size()]));
        this.factoryBean.setSpaceTypes(this.typeDescriptors.toArray(new SpaceTypeDescriptor[this.typeDescriptors.size()]));
        this.factoryBean.setQueryExtensionProviders(this.queryExtensionProviders.toArray(new QueryExtensionProvider[this.queryExtensionProviders.size()]));
        this.factoryBean.afterPropertiesSet();
        return (IJSpace)this.factoryBean.getObject();
    }

    public EmbeddedSpaceConfigurer addProperty(String name, String value) {
        this.validate();
        this.properties.setProperty(name, value);
        return this;
    }

    public EmbeddedSpaceConfigurer addProperties(Properties properties) {
        this.validate();
        this.properties.putAll((Map<?, ?>)properties);
        return this;
    }

    public EmbeddedSpaceConfigurer lookupGroups(String lookupGroups) {
        this.validate();
        this.factoryBean.setLookupGroups(lookupGroups);
        return this;
    }

    public EmbeddedSpaceConfigurer lookupGroups(String ... lookupGroups) {
        this.validate();
        this.factoryBean.setLookupGroups(StringUtils.arrayToCommaDelimitedString((Object[])lookupGroups));
        return this;
    }

    public EmbeddedSpaceConfigurer lookupLocators(String lookupLocators) {
        this.validate();
        this.factoryBean.setLookupLocators(lookupLocators);
        return this;
    }

    public EmbeddedSpaceConfigurer lookupLocators(String ... lookupLocators) {
        this.validate();
        this.factoryBean.setLookupLocators(StringUtils.arrayToCommaDelimitedString((Object[])lookupLocators));
        return this;
    }

    public EmbeddedSpaceConfigurer lookupTimeout(int lookupTimeout) {
        this.validate();
        this.factoryBean.setLookupTimeout(lookupTimeout);
        return this;
    }

    public EmbeddedSpaceConfigurer versioned(boolean versioned) {
        this.validate();
        this.factoryBean.setVersioned(versioned);
        return this;
    }

    public EmbeddedSpaceConfigurer credentials(String userName, String password) {
        return this.credentialsProvider((CredentialsProvider)new DefaultCredentialsProvider(userName, password));
    }

    public EmbeddedSpaceConfigurer credentialsProvider(CredentialsProvider credentialsProvider) {
        this.validate();
        this.factoryBean.setCredentialsProvider(credentialsProvider);
        return this;
    }

    public EmbeddedSpaceConfigurer secured(boolean secured) {
        this.validate();
        this.factoryBean.setSecured(secured);
        return this;
    }

    public EmbeddedSpaceConfigurer schema(String schema) {
        this.validate();
        this.factoryBean.setSchema(schema);
        return this;
    }

    public EmbeddedSpaceConfigurer mirrored(boolean mirrored) {
        this.validate();
        this.factoryBean.setMirrored(mirrored);
        return this;
    }

    public EmbeddedSpaceConfigurer addFilterProvider(FilterProviderFactory filterProviderFactory) {
        this.validate();
        this.filterProviderFactories.add(filterProviderFactory);
        return this;
    }

    public EmbeddedSpaceConfigurer addSpaceType(SpaceTypeDescriptor spaceType) {
        this.validate();
        this.typeDescriptors.add(spaceType);
        return this;
    }

    public EmbeddedSpaceConfigurer addQueryExtensionProvider(QueryExtensionProvider queryExtensionProvider) {
        this.validate();
        this.queryExtensionProviders.add(queryExtensionProvider);
        return this;
    }

    public EmbeddedSpaceConfigurer replicationFilterProvider(ReplicationFilterProviderFactory replicationFilterProvider) {
        this.validate();
        this.factoryBean.setReplicationFilterProvider(replicationFilterProvider);
        return this;
    }

    public EmbeddedSpaceConfigurer externalDataSource(ManagedDataSource externalDataSource) {
        this.validate();
        this.factoryBean.setExternalDataSource(externalDataSource);
        return this;
    }

    public EmbeddedSpaceConfigurer spaceDataSource(SpaceDataSource spaceDataSource) {
        this.validate();
        this.factoryBean.setSpaceDataSource(spaceDataSource);
        return this;
    }

    public EmbeddedSpaceConfigurer spaceSynchronizationEndpoint(SpaceSynchronizationEndpoint synchronizationEndpoint) {
        this.validate();
        this.factoryBean.setSpaceSynchronizationEndpoint(synchronizationEndpoint);
        return this;
    }

    public EmbeddedSpaceConfigurer cachePolicy(CachePolicy cachePolicy) {
        this.validate();
        this.factoryBean.setCachePolicy(cachePolicy);
        return this;
    }

    public EmbeddedSpaceConfigurer clusterInfo(ClusterInfo clusterInfo) {
        this.validate();
        this.factoryBean.setClusterInfo(clusterInfo);
        return this;
    }

    public EmbeddedSpaceConfigurer registerForSpaceModeNotifications(boolean registerForSpaceMode) {
        this.validate();
        this.factoryBean.setRegisterForSpaceModeNotifications(registerForSpaceMode);
        return this;
    }

    public EmbeddedSpaceConfigurer primaryBackupListener(ISpaceModeListener primaryBackupListener) {
        this.validate();
        this.factoryBean.setPrimaryBackupListener(primaryBackupListener);
        return this;
    }

    public EmbeddedSpaceConfigurer customComponent(SpaceCustomComponentFactoryBean customComponentFactoryBean) {
        this.validate();
        this.factoryBean.setCustomComponent(customComponentFactoryBean);
        return this;
    }

    public EmbeddedSpaceConfigurer distributedTransactionProcessingConfiguration(DistributedTransactionProcessingConfigurationFactoryBean distributedTransactionProcessingConfiguration) {
        this.validate();
        this.factoryBean.setDistributedTransactionProcessingConfiguration(distributedTransactionProcessingConfiguration);
        return this;
    }

    public EmbeddedSpaceConfigurer customCachePolicy(CustomCachePolicyFactoryBean customCachePolicy) {
        this.validate();
        this.factoryBean.setCustomCachePolicy(customCachePolicy);
        return this;
    }

    public EmbeddedSpaceConfigurer blobStoreDataPolicy(BlobStoreDataPolicyFactoryBean blobStoreDataPolicy) {
        this.validate();
        this.factoryBean.setBlobStoreDataPolicy(blobStoreDataPolicy);
        return this;
    }

    public EmbeddedSpaceConfigurer blobStoreDataPolicy(BlobStoreDataPolicyConfigurer blobStoreDataPolicy) {
        this.validate();
        if (blobStoreDataPolicy != null) {
            this.factoryBean.setCachePolicy(blobStoreDataPolicy.asCachePolicy());
        }
        return this;
    }

    public EmbeddedSpaceConfigurer attributeStore(AttributeStore attributeStore) {
        this.validate();
        this.factoryBean.attributeStore(attributeStore);
        return this;
    }
}

