/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.core.space;

import com.gigaspaces.internal.reflection.IField;
import com.gigaspaces.internal.reflection.ReflectionUtil;
import com.gigaspaces.internal.utils.collections.CopyOnUpdateMap;
import com.j_spaces.core.IJSpace;
import com.j_spaces.core.SpaceContext;
import com.j_spaces.core.filters.ISpaceFilter;
import com.j_spaces.core.filters.entry.ISpaceFilterEntry;
import java.lang.reflect.Field;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import net.jini.core.entry.UnusableEntryException;
import org.openspaces.core.GigaSpace;
import org.openspaces.core.GigaSpaceConfigurer;
import org.openspaces.core.cluster.ClusterInfo;
import org.openspaces.core.cluster.ClusterInfoAware;
import org.openspaces.core.executor.AutowireTask;
import org.openspaces.core.executor.AutowireTaskMarker;
import org.openspaces.core.executor.Task;
import org.openspaces.core.executor.TaskGigaSpace;
import org.openspaces.core.executor.TaskGigaSpaceAware;
import org.openspaces.core.executor.internal.InternalSpaceTaskWrapper;
import org.openspaces.core.executor.support.DelegatingTask;
import org.openspaces.core.executor.support.ProcessObjectsProvider;
import org.openspaces.core.space.AbstractSpaceFactoryBean;
import org.openspaces.remoting.ExecutorRemotingTask;
import org.openspaces.remoting.SpaceRemotingServiceExporter;
import org.springframework.beans.factory.config.AutowireCapableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.util.ReflectionUtils;

public class ExecutorSpaceFilter
implements ISpaceFilter {
    private static Object NO_FIELD = new Object();
    private final Map<Class, Object> tasksGigaSpaceInjectionMap = new CopyOnUpdateMap();
    private final AbstractSpaceFactoryBean spaceFactoryBean;
    private final ClusterInfo clusterInfo;
    private IJSpace space;
    private GigaSpace gigaSpace;
    private final Object lock = new Object();
    private volatile SpaceRemotingServiceExporter serviceExporter;

    public ExecutorSpaceFilter(AbstractSpaceFactoryBean spaceFactoryBean, ClusterInfo clusterInfo) {
        this.spaceFactoryBean = spaceFactoryBean;
        this.clusterInfo = clusterInfo;
    }

    public void init(IJSpace space, String filterId, String url, int priority) throws RuntimeException {
        this.space = space;
        this.gigaSpace = new GigaSpaceConfigurer(space).gigaSpace();
    }

    public void process(SpaceContext context, ISpaceFilterEntry entry, int operationCode) throws RuntimeException {
        if (operationCode != 20) {
            return;
        }
        ApplicationContext applicationContext = this.spaceFactoryBean.getApplicationContext();
        AutowireCapableBeanFactory beanFactory = null;
        if (applicationContext != null) {
            beanFactory = applicationContext.getAutowireCapableBeanFactory();
        }
        try {
            Task task = entry.getObject(this.space);
            if (task instanceof InternalSpaceTaskWrapper) {
                task = ((InternalSpaceTaskWrapper)((Object)task)).getTask();
            }
            if (task instanceof ExecutorRemotingTask) {
                ((ExecutorRemotingTask)task).setServiceExporter(this.getServiceExporter(applicationContext));
            }
            while (true) {
                if (task instanceof TaskGigaSpaceAware) {
                    ((TaskGigaSpaceAware)((Object)task)).setGigaSpace(this.gigaSpace);
                } else {
                    Object field = this.tasksGigaSpaceInjectionMap.get(task.getClass());
                    if (field != NO_FIELD) {
                        if (field != null) {
                            try {
                                ((IField)field).set(task, (Object)this.gigaSpace);
                            }
                            catch (IllegalAccessException e) {
                                throw new RuntimeException("Failed to set task GigaSpace field", e);
                            }
                        }
                        final AtomicReference ref = new AtomicReference();
                        ReflectionUtils.doWithFields(task.getClass(), (ReflectionUtils.FieldCallback)new ReflectionUtils.FieldCallback(){

                            public void doWith(Field field) throws IllegalArgumentException, IllegalAccessException {
                                if (field.isAnnotationPresent(TaskGigaSpace.class)) {
                                    ref.set(field);
                                }
                            }
                        });
                        if (ref.get() == null) {
                            this.tasksGigaSpaceInjectionMap.put(task.getClass(), NO_FIELD);
                        } else {
                            ((Field)ref.get()).setAccessible(true);
                            IField fastField = ReflectionUtil.createField((Field)((Field)ref.get()));
                            this.tasksGigaSpaceInjectionMap.put(task.getClass(), fastField);
                            try {
                                fastField.set(task, (Object)this.gigaSpace);
                            }
                            catch (IllegalAccessException e) {
                                throw new RuntimeException("Failed to set task GigaSpace field", e);
                            }
                        }
                    }
                }
                if (this.isAutowire(task)) {
                    Object[] objects;
                    if (beanFactory == null) {
                        throw new IllegalStateException("Task [" + task.getClass().getName() + "] is configured to do autowiring but the space was not started with application context");
                    }
                    beanFactory.autowireBeanProperties(task, 0, false);
                    beanFactory.initializeBean(task, task.getClass().getName());
                    if (task instanceof ProcessObjectsProvider && (objects = ((ProcessObjectsProvider)((Object)task)).getObjectsToProcess()) != null) {
                        for (Object obj : objects) {
                            if (obj == null) continue;
                            beanFactory.autowireBeanProperties(obj, 0, false);
                            beanFactory.initializeBean(obj, obj.getClass().getName());
                        }
                    }
                } else {
                    if (applicationContext != null && task instanceof ApplicationContextAware) {
                        ((ApplicationContextAware)task).setApplicationContext(applicationContext);
                    }
                    if (this.clusterInfo != null && task instanceof ClusterInfoAware) {
                        ((ClusterInfoAware)((Object)task)).setClusterInfo(this.clusterInfo);
                    }
                }
                if (task instanceof DelegatingTask) {
                    task = ((DelegatingTask)task).getDelegatedTask();
                    continue;
                }
                break;
            }
        }
        catch (UnusableEntryException unusableEntryException) {
            // empty catch block
        }
    }

    public void process(SpaceContext context, ISpaceFilterEntry[] entries, int operationCode) throws RuntimeException {
    }

    public void close() throws RuntimeException {
    }

    private boolean isAutowire(Object obj) {
        if (obj instanceof AutowireTaskMarker) {
            return true;
        }
        return obj.getClass().isAnnotationPresent(AutowireTask.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SpaceRemotingServiceExporter getServiceExporter(ApplicationContext applicationContext) {
        if (this.serviceExporter != null) {
            return this.serviceExporter;
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.serviceExporter == null) {
                this.serviceExporter = ExecutorRemotingTask.getServiceExporter(applicationContext);
            }
            return this.serviceExporter;
        }
    }
}

