/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.core.space;

import com.gigaspaces.attribute_store.AttributeStore;
import com.gigaspaces.client.ClusterConfig;
import com.gigaspaces.client.SpaceProxyFactory;
import com.gigaspaces.internal.lookup.SpaceUrlUtils;
import com.gigaspaces.internal.sync.mirror.MirrorDistributedTxnConfig;
import com.gigaspaces.query.sql.functions.SqlFunction;
import com.gigaspaces.server.SpaceCustomComponent;
import com.j_spaces.core.IJSpace;
import com.j_spaces.core.client.FinderException;
import com.j_spaces.core.filters.FilterProvider;
import com.j_spaces.core.filters.ISpaceFilter;
import java.net.MalformedURLException;
import java.util.HashMap;
import org.openspaces.core.cluster.ClusterInfo;
import org.openspaces.core.config.SpaceSqlFunctionBean;
import org.openspaces.core.space.AbstractSpaceFactoryBean;
import org.openspaces.core.space.CachePolicy;
import org.openspaces.core.space.CannotCreateSpaceException;
import org.openspaces.core.space.CannotFindSpaceException;
import org.openspaces.core.space.ExecutorSpaceFilter;
import org.openspaces.core.space.SecurityConfig;
import org.openspaces.core.space.filter.FilterProviderFactory;
import org.openspaces.core.space.filter.replication.ReplicationFilterProviderFactory;
import org.openspaces.core.transaction.DistributedTransactionProcessingConfigurationFactoryBean;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class InternalSpaceFactory {
    private static final boolean enableExecutorInjection = true;
    private final SpaceProxyFactory factory = new SpaceProxyFactory();
    private ClusterInfo clusterInfo;

    public SpaceProxyFactory getFactory() {
        return this.factory;
    }

    public ClusterInfo getClusterInfo() {
        return this.clusterInfo;
    }

    public void setClusterInfo(ClusterInfo clusterInfo) {
        this.clusterInfo = clusterInfo;
    }

    public void setCachePolicy(CachePolicy cachePolicy) {
        this.factory.setCachePolicyProperties(cachePolicy == null ? null : cachePolicy.toProps());
    }

    public void addCustomComponent(SpaceCustomComponent component) {
        this.factory.addCustomComponent(component);
    }

    public void setDistributedTransactionProcessingConfiguration(DistributedTransactionProcessingConfigurationFactoryBean distributedTransactionProcessingConfiguration) {
        MirrorDistributedTxnConfig mirrorDistributedTxnConfig = null;
        if (distributedTransactionProcessingConfiguration != null) {
            mirrorDistributedTxnConfig = new MirrorDistributedTxnConfig().setDistributedTransactionWaitForOperations(distributedTransactionProcessingConfiguration.getDistributedTransactionWaitForOperations()).setDistributedTransactionWaitTimeout(distributedTransactionProcessingConfiguration.getDistributedTransactionWaitTimeout());
        }
        this.factory.setMirrorDistributedTxnConfig(mirrorDistributedTxnConfig);
    }

    public void setFilterProviders(FilterProviderFactory[] filterProviders) {
        FilterProvider[] spaceFilterProviders = null;
        if (filterProviders != null) {
            spaceFilterProviders = new FilterProvider[filterProviders.length];
            for (int i = 0; i < filterProviders.length; ++i) {
                spaceFilterProviders[i] = filterProviders[i].getFilterProvider();
            }
        }
        this.factory.setFilterProviders(spaceFilterProviders);
    }

    public void setReplicationFilterProvider(ReplicationFilterProviderFactory replicationFilterProvider) {
        this.factory.setReplicationFilterProvider(replicationFilterProvider == null ? null : replicationFilterProvider.getFilterProvider());
    }

    public void setSecurityConfig(SecurityConfig securityConfig) {
        this.factory.setCredentialsProvider(securityConfig == null ? null : securityConfig.getCredentialsProvider());
    }

    public void setAttributeStore(AttributeStore attributeStore) {
        this.factory.setAttributeStore(attributeStore);
    }

    public IJSpace create(AbstractSpaceFactoryBean spaceFactoryBean, String url) {
        Assert.notNull((Object)url, (String)"url property is required");
        boolean isRemote = SpaceUrlUtils.isRemoteProtocol((String)url);
        this.factory.setClusterConfig(InternalSpaceFactory.toClusterConfig(url, this.clusterInfo));
        this.beforeCreateSpace(spaceFactoryBean, isRemote);
        try {
            return this.factory.createSpaceProxy(url);
        }
        catch (MalformedURLException e) {
            throw new CannotCreateSpaceException("Failed to parse url [" + url + "]", e);
        }
        catch (FinderException e) {
            if (isRemote) {
                throw new CannotFindSpaceException("Failed to find space with url " + url + "", e);
            }
            throw new CannotCreateSpaceException("Failed to create space with url " + url + "", e);
        }
    }

    public IJSpace create(AbstractSpaceFactoryBean spaceFactoryBean, String name, boolean isRemote) {
        if (name == null) {
            name = spaceFactoryBean.getName();
        }
        Assert.notNull((Object)name, (String)"name property is required");
        this.factory.setClusterConfig(InternalSpaceFactory.toClusterConfig(this.clusterInfo));
        this.beforeCreateSpace(spaceFactoryBean, isRemote);
        try {
            return this.factory.createSpaceProxy(name, isRemote);
        }
        catch (MalformedURLException e) {
            throw new CannotCreateSpaceException("Failed to build url for space [" + name + "]", e);
        }
        catch (FinderException e) {
            if (isRemote) {
                throw new CannotFindSpaceException("Failed to find space " + name + "", e);
            }
            throw new CannotCreateSpaceException("Failed to create space " + name + "", e);
        }
    }

    private static ClusterConfig toClusterConfig(String url, ClusterInfo clusterInfo) {
        if (clusterInfo == null || SpaceUrlUtils.isRemoteProtocol((String)url)) {
            return null;
        }
        if (url.indexOf("cluster_schema=") == -1 && !StringUtils.hasText((String)clusterInfo.getSchema())) {
            return null;
        }
        ClusterConfig clusterConfig = new ClusterConfig();
        if (url.indexOf("cluster_schema=") == -1) {
            clusterConfig.setSchema(clusterInfo.getSchema());
        }
        if (url.indexOf("&total_members=") == -1 && url.indexOf("?total_members=") == -1) {
            clusterConfig.setNumberOfInstances(clusterInfo.getNumberOfInstances());
            clusterConfig.setNumberOfBackups(clusterInfo.getNumberOfBackups());
        }
        if (url.indexOf("&id=") == -1 && url.indexOf("?id=") == -1) {
            clusterConfig.setInstanceId(clusterInfo.getInstanceId());
        }
        if (url.indexOf("&backup_id=") == -1 && url.indexOf("?backup_id=") == -1) {
            clusterConfig.setBackupId(clusterInfo.getBackupId());
        }
        return clusterConfig;
    }

    private static ClusterConfig toClusterConfig(ClusterInfo clusterInfo) {
        if (clusterInfo == null) {
            return null;
        }
        if (!StringUtils.hasText((String)clusterInfo.getSchema())) {
            return null;
        }
        ClusterConfig clusterConfig = new ClusterConfig();
        clusterConfig.setSchema(clusterInfo.getSchema());
        clusterConfig.setNumberOfInstances(clusterInfo.getNumberOfInstances());
        clusterConfig.setNumberOfBackups(clusterInfo.getNumberOfBackups());
        clusterConfig.setInstanceId(clusterInfo.getInstanceId());
        clusterConfig.setBackupId(clusterInfo.getBackupId());
        return clusterConfig;
    }

    private void beforeCreateSpace(AbstractSpaceFactoryBean spaceFactoryBean, boolean isRemote) {
        if (!isRemote) {
            FilterProvider filterProvider = new FilterProvider("InjectionExecutorFilter", (ISpaceFilter)new ExecutorSpaceFilter(spaceFactoryBean, this.clusterInfo));
            filterProvider.setOpCodes(new int[]{20});
            this.factory.addFilterProvider(filterProvider);
        }
    }

    public void setSpaceSqlFunction(SpaceSqlFunctionBean[] spaceSqlFunctionBeans) {
        HashMap<String, SqlFunction> map = new HashMap<String, SqlFunction>();
        for (SpaceSqlFunctionBean spaceSqlFunctionBean : spaceSqlFunctionBeans) {
            String functionName = spaceSqlFunctionBean.getFunctionName();
            SqlFunction sqlFunction = null;
            try {
                sqlFunction = (SqlFunction)spaceSqlFunctionBean.getSqlFunction();
            }
            catch (ClassCastException e) {
                throw new RuntimeException("provided class is not a SqlFunction type");
            }
            if (sqlFunction == null) continue;
            map.put(functionName, sqlFunction);
        }
        this.factory.setUserDefineSqlFunctions(map);
    }
}

