/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.core.space;

import java.util.Properties;
import org.openspaces.core.space.CachePolicy;

public class LruCachePolicy
implements CachePolicy {
    private Integer size;
    private Integer initialLoadPercentage;

    public LruCachePolicy size(int size) {
        this.setSize(size);
        return this;
    }

    public LruCachePolicy initialLoadPercentage(int initialLoadPercentage) {
        this.setInitialLoadPercentage(initialLoadPercentage);
        return this;
    }

    public LruCachePolicy setSize(Integer size) {
        this.size = size;
        return this;
    }

    public LruCachePolicy setInitialLoadPercentage(int initialLoadPercentage) {
        this.initialLoadPercentage = initialLoadPercentage;
        return this;
    }

    @Override
    public Properties toProps() {
        Properties props = new Properties();
        props.setProperty("space-config.engine.cache_policy", "0");
        if (this.size != null) {
            props.setProperty("space-config.engine.cache_size", this.size.toString());
        }
        if (this.initialLoadPercentage != null) {
            props.setProperty("space-config.engine.initial_load", this.initialLoadPercentage.toString());
        }
        return props;
    }
}

