/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.core.space;

import com.gigaspaces.security.directory.CredentialsProvider;
import com.gigaspaces.security.directory.CredentialsProviderHelper;
import com.gigaspaces.security.directory.DefaultCredentialsProvider;
import java.util.Properties;
import org.springframework.util.StringUtils;

public class SecurityConfig {
    private String username;
    private String password;
    private CredentialsProvider credentialsProvider;

    public SecurityConfig() {
    }

    public SecurityConfig(String username, String password) {
        this.username = username;
        this.password = password;
    }

    public SecurityConfig(CredentialsProvider credentialsProvider) {
        this.credentialsProvider = credentialsProvider;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public CredentialsProvider getCredentialsProvider() {
        if (this.credentialsProvider != null) {
            return this.credentialsProvider;
        }
        return this.isFilled() ? new DefaultCredentialsProvider(this.username, this.password) : null;
    }

    public boolean isFilled() {
        if (this.credentialsProvider != null) {
            return true;
        }
        return StringUtils.hasText((String)this.username) && !"${security.username}".equals(this.username) && StringUtils.hasText((String)this.password) && !"${security.password}".equals(this.password);
    }

    public static SecurityConfig fromMarshalledProperties(Properties properties) {
        CredentialsProvider credentials = CredentialsProviderHelper.extractMarshalledCredentials((Properties)properties, (boolean)false);
        return credentials == null ? null : new SecurityConfig(credentials);
    }
}

