/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.core.space;

import com.gigaspaces.security.directory.CredentialsProvider;
import com.gigaspaces.security.directory.DefaultCredentialsProvider;
import com.j_spaces.core.IJSpace;
import java.util.Map;
import java.util.Properties;
import org.openspaces.core.space.AbstractSpaceConfigurer;
import org.openspaces.core.space.SpaceProxyFactoryBean;
import org.springframework.util.StringUtils;

public class SpaceProxyConfigurer
extends AbstractSpaceConfigurer {
    private final SpaceProxyFactoryBean factoryBean;
    private final Properties properties = new Properties();

    public SpaceProxyConfigurer(String name) {
        this.factoryBean = new SpaceProxyFactoryBean(name);
    }

    @Override
    public void close() {
        this.factoryBean.close();
    }

    @Override
    protected IJSpace createSpace() {
        this.factoryBean.setProperties(this.properties);
        this.factoryBean.afterPropertiesSet();
        return (IJSpace)this.factoryBean.getObject();
    }

    public SpaceProxyConfigurer addProperty(String name, String value) {
        this.validate();
        this.properties.setProperty(name, value);
        return this;
    }

    public SpaceProxyConfigurer addProperties(Properties properties) {
        this.validate();
        this.properties.putAll((Map<?, ?>)properties);
        return this;
    }

    public SpaceProxyConfigurer instanceId(String instanceID) {
        this.validate();
        this.factoryBean.setInstanceId(instanceID);
        return this;
    }

    public SpaceProxyConfigurer lookupGroups(String ... lookupGroups) {
        this.validate();
        this.factoryBean.setLookupGroups(StringUtils.arrayToCommaDelimitedString((Object[])lookupGroups));
        return this;
    }

    public SpaceProxyConfigurer lookupGroups(String lookupGroups) {
        this.validate();
        this.factoryBean.setLookupGroups(lookupGroups);
        return this;
    }

    public SpaceProxyConfigurer lookupLocators(String lookupLocators) {
        this.validate();
        this.factoryBean.setLookupLocators(lookupLocators);
        return this;
    }

    public SpaceProxyConfigurer lookupLocators(String ... lookupLocators) {
        this.validate();
        this.factoryBean.setLookupLocators(StringUtils.arrayToCommaDelimitedString((Object[])lookupLocators));
        return this;
    }

    public SpaceProxyConfigurer lookupTimeout(int lookupTimeout) {
        this.validate();
        this.factoryBean.setLookupTimeout(lookupTimeout);
        return this;
    }

    public SpaceProxyConfigurer versioned(boolean versioned) {
        this.validate();
        this.factoryBean.setVersioned(versioned);
        return this;
    }

    public SpaceProxyConfigurer credentials(String userName, String password) {
        return this.credentialsProvider((CredentialsProvider)new DefaultCredentialsProvider(userName, password));
    }

    public SpaceProxyConfigurer credentialsProvider(CredentialsProvider credentialsProvider) {
        this.validate();
        this.factoryBean.setCredentialsProvider(credentialsProvider);
        return this;
    }
}

