/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.core.space;

import com.gigaspaces.internal.client.spaceproxy.ISpaceProxy;
import com.gigaspaces.internal.cluster.SpaceClusterInfo;
import com.gigaspaces.server.SpaceCustomComponent;
import com.j_spaces.core.IJSpace;
import com.j_spaces.core.admin.IInternalRemoteJSpaceAdmin;
import com.j_spaces.core.client.SpaceURL;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import net.jini.core.lookup.ServiceID;
import org.openspaces.core.space.SpaceType;
import org.openspaces.core.util.SpaceUtils;
import org.openspaces.pu.service.PlainServiceDetails;

public class SpaceServiceDetails
extends PlainServiceDetails {
    private static final long serialVersionUID = -8974518417753189880L;
    public static final String SERVICE_TYPE = "space";
    private IJSpace space;
    private IJSpace directSpace;
    private IInternalRemoteJSpaceAdmin directSpaceAdmin;

    public SpaceServiceDetails() {
    }

    public SpaceServiceDetails(IJSpace space) {
        this(null, space);
    }

    public SpaceServiceDetails(String id, IJSpace space) {
        super(id, SERVICE_TYPE, null, null, null);
        this.space = space;
        this.getAttributes().put("service-id", new ServiceID(space.getReferentUuid().getMostSignificantBits(), space.getReferentUuid().getLeastSignificantBits()));
        SpaceURL spaceURL = space.getFinderURL();
        this.serviceSubType = "embedded";
        SpaceType spaceType = SpaceType.EMBEDDED;
        this.getAttributes().put("mirror", false);
        if (space.getCacheTypeName().equals("LocalView")) {
            this.serviceSubType = "localview";
            spaceType = SpaceType.LOCAL_VIEW;
        } else if (space.getCacheTypeName().equals("LocalCache")) {
            this.serviceSubType = "localcache";
            spaceType = SpaceType.LOCAL_CACHE;
        } else if (SpaceUtils.isRemoteProtocol(space)) {
            this.serviceSubType = "remote";
            spaceType = SpaceType.REMOTE;
        } else {
            SpaceClusterInfo clusterInfo = space.getDirectProxy().getSpaceClusterInfo();
            if (clusterInfo.isMirrorServiceEnabled()) {
                this.getAttributes().put("mirror", true);
            }
            for (SpaceCustomComponent component : clusterInfo.getCustomComponents().values()) {
                this.getAttributes().put(component.getServiceDetailAttributeName(), component.getServiceDetailAttributeValue());
            }
            try {
                this.directSpace = space.getDirectProxy().getNonClusteredProxy();
                this.directSpaceAdmin = (IInternalRemoteJSpaceAdmin)this.directSpace.getAdmin();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.getAttributes().put("space-type", (Object)spaceType);
        this.getAttributes().put("space-name", spaceURL.getSpaceName());
        this.getAttributes().put("space-container-name", spaceURL.getContainerName());
        this.getAttributes().put("clustered", ((ISpaceProxy)space).isClustered());
        this.description = spaceURL.getSpaceName();
        this.longDescription = spaceURL.getContainerName() + ":" + spaceURL.getSpaceName();
        this.getAttributes().put("url", space.getFinderURL().toString());
        this.getAttributes().put("spaceUrl", space.getFinderURL());
        if (id == null) {
            this.id = this.serviceSubType + ":" + spaceURL.getSpaceName();
        }
    }

    public String getName() {
        return (String)this.getAttributes().get("space-name");
    }

    public String getContainerName() {
        return (String)this.getAttributes().get("space-container-name");
    }

    public ServiceID getServiceID() {
        return (ServiceID)this.getAttributes().get("service-id");
    }

    public SpaceType getSpaceType() {
        return (SpaceType)((Object)this.getAttributes().get("space-type"));
    }

    public Boolean isMirror() {
        return (Boolean)this.getAttributes().get("mirror");
    }

    public Boolean isClustered() {
        return (Boolean)this.getAttributes().get("clustered");
    }

    public String getUrl() {
        return (String)this.getAttributes().get("url");
    }

    public SpaceURL getSpaceUrl() {
        return (SpaceURL)this.getAttributes().get("spaceUrl");
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
    }

    public static final class Attributes {
        public static final String SERVICEID = "service-id";
        public static final String SPACENAME = "space-name";
        public static final String SPACECONTAINERNAME = "space-container-name";
        public static final String SPACETYPE = "space-type";
        public static final String CLUSTERED = "clustered";
        public static final String URL = "url";
        public static final String SPACE_URL = "spaceUrl";
        public static final String MIRROR = "mirror";
    }
}

