/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.core.space;

import com.gigaspaces.attribute_store.AttributeStore;
import com.gigaspaces.cluster.activeelection.ISpaceModeListener;
import com.gigaspaces.datasource.ManagedDataSource;
import com.gigaspaces.datasource.SpaceDataSource;
import com.gigaspaces.metadata.SpaceTypeDescriptor;
import com.gigaspaces.security.directory.CredentialsProvider;
import com.gigaspaces.security.directory.DefaultCredentialsProvider;
import com.gigaspaces.security.directory.UserDetails;
import com.gigaspaces.sync.SpaceSynchronizationEndpoint;
import com.j_spaces.core.IJSpace;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.openspaces.core.cluster.ClusterInfo;
import org.openspaces.core.space.CachePolicy;
import org.openspaces.core.space.SecurityConfig;
import org.openspaces.core.space.SpaceConfigurer;
import org.openspaces.core.space.UrlSpaceFactoryBean;
import org.openspaces.core.space.filter.FilterProviderFactory;
import org.openspaces.core.space.filter.replication.ReplicationFilterProviderFactory;
import org.springframework.util.StringUtils;

public class UrlSpaceConfigurer
implements SpaceConfigurer {
    private UrlSpaceFactoryBean urlSpaceFactoryBean;
    private IJSpace space;
    private final Properties properties = new Properties();
    private final Properties urlProperties = new Properties();
    private final Map<String, Object> parameters = new HashMap<String, Object>();
    private final List<FilterProviderFactory> filterProviderFactories = new ArrayList<FilterProviderFactory>();
    private final List<SpaceTypeDescriptor> typeDescriptors = new ArrayList<SpaceTypeDescriptor>();

    public UrlSpaceConfigurer(String url) {
        this.urlSpaceFactoryBean = new UrlSpaceFactoryBean(url);
    }

    public void setUrlSpaceFactoryBean(UrlSpaceFactoryBean urlSpaceFactoryBean) {
        this.urlSpaceFactoryBean = urlSpaceFactoryBean;
    }

    public UrlSpaceConfigurer addParameter(String name, String value) {
        this.validate();
        this.parameters.put(name, value);
        return this;
    }

    public UrlSpaceConfigurer addProperty(String name, String value) {
        this.validate();
        this.properties.setProperty(name, value);
        return this;
    }

    public UrlSpaceConfigurer addProperties(Properties properties) {
        this.validate();
        this.properties.putAll((Map<?, ?>)properties);
        return this;
    }

    public UrlSpaceConfigurer addUrlProperty(String name, String value) {
        this.validate();
        this.urlProperties.setProperty(name, value);
        return this;
    }

    public UrlSpaceConfigurer schema(String schema) {
        this.validate();
        this.urlSpaceFactoryBean.setSchema(schema);
        return this;
    }

    @Deprecated
    public UrlSpaceConfigurer fifo(boolean fifo) {
        this.validate();
        this.urlSpaceFactoryBean.setFifo(fifo);
        return this;
    }

    public UrlSpaceConfigurer lookupGroups(String lookupGroups) {
        this.validate();
        this.urlSpaceFactoryBean.setLookupGroups(lookupGroups);
        return this;
    }

    public UrlSpaceConfigurer lookupGroups(String ... lookupGroups) {
        this.validate();
        this.urlSpaceFactoryBean.setLookupGroups(StringUtils.arrayToCommaDelimitedString((Object[])lookupGroups));
        return this;
    }

    public UrlSpaceConfigurer lookupLocators(String lookupLocators) {
        this.validate();
        this.urlSpaceFactoryBean.setLookupLocators(lookupLocators);
        return this;
    }

    public UrlSpaceConfigurer lookupLocators(String ... lookupLocators) {
        this.validate();
        this.urlSpaceFactoryBean.setLookupLocators(StringUtils.arrayToCommaDelimitedString((Object[])lookupLocators));
        return this;
    }

    public UrlSpaceConfigurer lookupTimeout(int lookupTimeout) {
        this.validate();
        this.urlSpaceFactoryBean.setLookupTimeout(lookupTimeout);
        return this;
    }

    public UrlSpaceConfigurer versioned(boolean versioned) {
        this.validate();
        this.urlSpaceFactoryBean.setVersioned(versioned);
        return this;
    }

    public UrlSpaceConfigurer noWriteLease(boolean noWriteLease) {
        this.validate();
        this.urlSpaceFactoryBean.setNoWriteLease(noWriteLease);
        return this;
    }

    public UrlSpaceConfigurer mirror(boolean mirror) {
        this.validate();
        this.urlSpaceFactoryBean.setMirror(mirror);
        return this;
    }

    public UrlSpaceConfigurer addFilterProvider(FilterProviderFactory filterProviderFactory) {
        this.validate();
        this.filterProviderFactories.add(filterProviderFactory);
        return this;
    }

    public UrlSpaceConfigurer addSpaceType(SpaceTypeDescriptor spaceType) {
        this.validate();
        this.typeDescriptors.add(spaceType);
        return this;
    }

    public UrlSpaceConfigurer replicationFilterProvider(ReplicationFilterProviderFactory replicationFilterProvider) {
        this.validate();
        this.urlSpaceFactoryBean.setReplicationFilterProvider(replicationFilterProvider);
        return this;
    }

    public UrlSpaceConfigurer externalDataSource(ManagedDataSource externalDataSource) {
        this.validate();
        this.urlSpaceFactoryBean.setExternalDataSource(externalDataSource);
        return this;
    }

    public UrlSpaceConfigurer spaceDataSource(SpaceDataSource spaceDataSource) {
        this.validate();
        this.urlSpaceFactoryBean.setSpaceDataSource(spaceDataSource);
        return this;
    }

    public UrlSpaceConfigurer spaceSynchronizationEndpoint(SpaceSynchronizationEndpoint synchronizationEndpoint) {
        this.validate();
        this.urlSpaceFactoryBean.setSpaceSynchronizationEndpoint(synchronizationEndpoint);
        return this;
    }

    public UrlSpaceConfigurer cachePolicy(CachePolicy cachePolicy) {
        this.validate();
        this.urlSpaceFactoryBean.setCachePolicy(cachePolicy);
        return this;
    }

    public UrlSpaceConfigurer clusterInfo(ClusterInfo clusterInfo) {
        this.validate();
        this.urlSpaceFactoryBean.setClusterInfo(clusterInfo);
        return this;
    }

    public UrlSpaceConfigurer registerForSpaceModeNotifications(boolean registerForSpaceMode) {
        this.validate();
        this.urlSpaceFactoryBean.setRegisterForSpaceModeNotifications(registerForSpaceMode);
        return this;
    }

    public UrlSpaceConfigurer secured(boolean secured) {
        this.urlSpaceFactoryBean.setSecured(secured);
        return this;
    }

    @Deprecated
    public UrlSpaceConfigurer userDetails(String userName, String password) {
        return this.securityConfig(new SecurityConfig(userName, password));
    }

    @Deprecated
    public UrlSpaceConfigurer userDetails(UserDetails userDetails) {
        return this.credentialsProvider((CredentialsProvider)new DefaultCredentialsProvider(userDetails));
    }

    public UrlSpaceConfigurer credentials(String userName, String password) {
        return this.securityConfig(new SecurityConfig(userName, password));
    }

    public UrlSpaceConfigurer credentialsProvider(CredentialsProvider credentialsProvider) {
        return this.securityConfig(new SecurityConfig(credentialsProvider));
    }

    public UrlSpaceConfigurer securityConfig(SecurityConfig securityConfig) {
        this.validate();
        this.urlSpaceFactoryBean.setSecurityConfig(securityConfig);
        return this;
    }

    public UrlSpaceConfigurer primaryBackupListener(ISpaceModeListener primaryBackupListener) {
        this.validate();
        this.urlSpaceFactoryBean.setPrimaryBackupListener(primaryBackupListener);
        return this;
    }

    public UrlSpaceConfigurer attributeStore(AttributeStore attributeStore) {
        this.validate();
        this.urlSpaceFactoryBean.attributeStore(attributeStore);
        return this;
    }

    public IJSpace create() {
        if (this.space == null) {
            this.urlSpaceFactoryBean.setParameters(this.parameters);
            this.urlSpaceFactoryBean.setProperties(this.properties);
            this.urlSpaceFactoryBean.setUrlProperties(this.urlProperties);
            this.urlSpaceFactoryBean.setFilterProviders(this.filterProviderFactories.toArray(new FilterProviderFactory[this.filterProviderFactories.size()]));
            this.urlSpaceFactoryBean.setSpaceTypes(this.typeDescriptors.toArray(new SpaceTypeDescriptor[this.typeDescriptors.size()]));
            this.urlSpaceFactoryBean.afterPropertiesSet();
            this.space = (IJSpace)this.urlSpaceFactoryBean.getObject();
        }
        return this.space;
    }

    @Override
    public IJSpace space() {
        return this.create();
    }

    @Override
    public void close() {
        this.urlSpaceFactoryBean.close();
    }

    private void validate() {
        if (this.space != null) {
            throw new IllegalArgumentException("Can't invoke method, space() has already been called");
        }
    }
}

