/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.core.space.filter;

import com.j_spaces.core.filters.FilterProvider;
import com.j_spaces.core.filters.ISpaceFilter;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Map;
import org.openspaces.core.space.filter.AbstractFilterProviderFactoryBean;
import org.openspaces.core.space.filter.FilterOperationDelegate;
import org.openspaces.core.space.filter.FilterOperationDelegateInvoker;

public abstract class AbstractFilterProviderAdapterFactoryBean
extends AbstractFilterProviderFactoryBean {
    @Override
    protected FilterProvider doGetFilterProvider() throws IllegalArgumentException {
        Map<Integer, FilterOperationDelegateInvoker> invokerLookup = this.doGetInvokerLookup();
        if (invokerLookup.size() == 0) {
            throw new IllegalArgumentException("No invoker found in filter [" + this.getFilter() + "]");
        }
        FilterOperationDelegate delegate = new FilterOperationDelegate(this.getFilter(), invokerLookup);
        delegate.setInitMethod(this.doGetInitMethod());
        delegate.setCloseMethod(this.doGetCloseMethod());
        FilterProvider filterProvider = new FilterProvider(this.getBeanName(), (ISpaceFilter)delegate);
        ArrayList<Integer> operationCodes = new ArrayList<Integer>();
        for (FilterOperationDelegateInvoker invoker : invokerLookup.values()) {
            operationCodes.add(invoker.getOperationCode());
        }
        int[] opCodes = new int[operationCodes.size()];
        for (int i = 0; i < opCodes.length; ++i) {
            opCodes[i] = (Integer)operationCodes.get(i);
        }
        filterProvider.setOpCodes(opCodes);
        return filterProvider;
    }

    protected void addInvoker(Map<Integer, FilterOperationDelegateInvoker> invokerLookup, Method method, int operationCode) throws IllegalArgumentException {
        FilterOperationDelegateInvoker invoker = invokerLookup.get(operationCode);
        if (invoker != null) {
            throw new IllegalArgumentException("Filter adapter only allows for a single method for each operation. operation [" + operationCode + "] has method [" + invoker.getProcessMethod().getName() + "] and method [" + method.getName() + "]");
        }
        invokerLookup.put(operationCode, new FilterOperationDelegateInvoker(operationCode, method));
    }

    protected abstract Map<Integer, FilterOperationDelegateInvoker> doGetInvokerLookup();

    protected abstract Method doGetInitMethod();

    protected abstract Method doGetCloseMethod();
}

