/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.core.space.filter;

import com.j_spaces.core.IJSpace;
import com.j_spaces.core.SpaceContext;
import com.j_spaces.core.filters.ISpaceFilter;
import com.j_spaces.core.filters.entry.ISpaceFilterEntry;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import org.openspaces.core.space.filter.FilterExecutionException;
import org.openspaces.core.space.filter.FilterOperationDelegateInvoker;

public class FilterOperationDelegate
implements ISpaceFilter {
    private Object delegate;
    private Map<Integer, FilterOperationDelegateInvoker> invokerLookup;
    private Method initMethod;
    private Method closeMethod;
    private IJSpace space;

    public FilterOperationDelegate(Object delegate, Map<Integer, FilterOperationDelegateInvoker> invokerLookup) {
        this.delegate = delegate;
        this.invokerLookup = invokerLookup;
    }

    public void setInitMethod(Method initMethod) {
        this.initMethod = initMethod;
        if (initMethod != null) {
            initMethod.setAccessible(true);
        }
    }

    public void setCloseMethod(Method closeMethod) {
        this.closeMethod = closeMethod;
        if (closeMethod != null) {
            closeMethod.setAccessible(true);
        }
    }

    public void init(IJSpace space, String filterId, String url, int priority) throws RuntimeException {
        this.space = space;
        if (this.initMethod == null) {
            return;
        }
        Object[] params = null;
        if (this.initMethod.getParameterTypes().length == 1) {
            params = new Object[]{space};
        }
        try {
            this.initMethod.invoke(this.delegate, params);
        }
        catch (IllegalAccessException e) {
            throw new FilterExecutionException("Failed to access init method [" + this.initMethod.getName() + "]", e);
        }
        catch (InvocationTargetException e) {
            throw new FilterExecutionException("Failed to execute init method [" + this.initMethod.getName() + "]", e);
        }
    }

    public void process(SpaceContext context, ISpaceFilterEntry entry, int operationCode) throws RuntimeException {
        FilterOperationDelegateInvoker invoker = this.invokerLookup.get(operationCode);
        if (invoker != null) {
            invoker.invokeProcess(this.space, this.delegate, context, entry);
        }
    }

    public void process(SpaceContext context, ISpaceFilterEntry[] entries, int operationCode) throws RuntimeException {
        FilterOperationDelegateInvoker invoker = this.invokerLookup.get(operationCode);
        if (invoker != null) {
            invoker.invokeProcess(this.space, this.delegate, context, entries);
        }
    }

    public void close() throws RuntimeException {
        if (this.closeMethod == null) {
            return;
        }
        try {
            this.closeMethod.invoke(this.delegate, new Object[0]);
        }
        catch (IllegalAccessException e) {
            throw new FilterExecutionException("Failed to access close method [" + this.closeMethod.getName() + "]", e);
        }
        catch (InvocationTargetException e) {
            throw new FilterExecutionException("Failed to execute close method [" + this.closeMethod.getName() + "]", e);
        }
    }
}

