/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.core.space.filter;

import com.gigaspaces.internal.reflection.IMethod;
import com.gigaspaces.internal.reflection.ReflectionUtil;
import com.j_spaces.core.IJSpace;
import com.j_spaces.core.SpaceContext;
import com.j_spaces.core.filters.entry.ISpaceFilterEntry;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.jini.core.entry.UnusableEntryException;
import org.openspaces.core.space.filter.FilterExecutionException;
import org.springframework.util.ClassUtils;

class FilterOperationDelegateInvoker {
    private boolean filterOnTypes = true;
    private int operationCode;
    private IMethod processMethod;
    private Class<?>[] parameterTypes;
    private Map<String, Class> classCache = new ConcurrentHashMap<String, Class>();

    public FilterOperationDelegateInvoker(int operationCode, Method processMethod) {
        this.operationCode = operationCode;
        this.processMethod = ReflectionUtil.createMethod((Method)processMethod);
        this.parameterTypes = processMethod.getParameterTypes();
    }

    public int getOperationCode() {
        return this.operationCode;
    }

    public IMethod getProcessMethod() {
        return this.processMethod;
    }

    public void invokeProcess(IJSpace space, Object delegate, SpaceContext context, ISpaceFilterEntry entry) throws FilterExecutionException {
        Object[] params;
        if (this.parameterTypes.length == 0) {
            params = null;
        } else if (this.operationCode == 6) {
            params = new Object[]{context};
        } else {
            Object entryParam = entry;
            if (entryParam != null && (entryParam = this.detectSpaceFilterEntryParam(this.parameterTypes[0], space, entry)) == null) {
                return;
            }
            if (this.parameterTypes.length == 1) {
                params = new Object[]{entryParam};
            } else if (this.parameterTypes.length == 2) {
                params = new Object[]{entryParam, this.operationCode};
            } else if (this.parameterTypes.length == 3) {
                params = new Object[]{entryParam, this.operationCode, context};
            } else {
                throw new FilterExecutionException("Method [" + this.processMethod.getName() + "] should not have more than 3 parameters");
            }
        }
        try {
            this.processMethod.invoke(delegate, params);
        }
        catch (IllegalAccessException e) {
            throw new FilterExecutionException("Failed to access method [" + this.processMethod.getName() + "] with operation code [" + this.operationCode + "]", e);
        }
        catch (InvocationTargetException e) {
            throw new FilterExecutionException("Failed to execute method [" + this.processMethod.getName() + "] with operation code [" + this.operationCode + "]", e.getTargetException());
        }
        catch (Exception e) {
            throw new FilterExecutionException("Failed to execute method [" + this.processMethod.getName() + "] with operation code [" + this.operationCode + "]", e);
        }
    }

    public void invokeProcess(IJSpace space, Object delegate, SpaceContext context, ISpaceFilterEntry[] entries) throws FilterExecutionException {
        Object[] params = null;
        if (this.parameterTypes.length == 0) {
            params = null;
        } else {
            Object entryParam1 = entries[0];
            if (entryParam1 != null && (entryParam1 = this.detectSpaceFilterEntryParam(this.parameterTypes[0], space, entries[0])) == null) {
                return;
            }
            if (this.parameterTypes.length == 1) {
                params = new Object[]{entryParam1};
            } else {
                Object entryParam2 = entries[1];
                if (entryParam2 != null && (entryParam2 = this.detectSpaceFilterEntryParam(this.parameterTypes[1], space, entries[1])) == null) {
                    return;
                }
                if (this.parameterTypes.length == 2) {
                    params = new Object[]{entryParam1, entryParam2};
                } else if (this.parameterTypes.length == 3) {
                    params = new Object[]{entryParam1, entryParam2, this.operationCode};
                } else if (this.parameterTypes.length == 4) {
                    params = new Object[]{entryParam1, entryParam2, this.operationCode, context};
                } else {
                    throw new FilterExecutionException("Method [" + this.processMethod.getName() + "] should not have more than 4 parameters");
                }
            }
        }
        try {
            this.processMethod.invoke(delegate, params);
        }
        catch (IllegalAccessException e) {
            throw new FilterExecutionException("Failed to access method [" + this.processMethod.getName() + "] with operation code [" + this.operationCode + "]", e);
        }
        catch (InvocationTargetException e) {
            throw new FilterExecutionException("Failed to execute method [" + this.processMethod.getName() + "] with operation code [" + this.operationCode + "]", e.getTargetException());
        }
        catch (Exception e) {
            throw new FilterExecutionException("Failed to execute method [" + this.processMethod.getName() + "] with operation code [" + this.operationCode + "]", e);
        }
    }

    private Object detectSpaceFilterEntryParam(Class paramType, IJSpace space, ISpaceFilterEntry entry) throws FilterExecutionException {
        if (ISpaceFilterEntry.class.isAssignableFrom(paramType)) {
            return entry;
        }
        if (entry.getClassName() == null) {
            return null;
        }
        if (this.filterOnTypes) {
            Class<?> entryClass = this.classCache.get(entry.getClassName());
            if (entryClass == null) {
                try {
                    entryClass = ClassUtils.getDefaultClassLoader().loadClass(entry.getClassName());
                }
                catch (ClassNotFoundException e) {
                    throw new FilterExecutionException("Failed to find class [" + entry.getClassName() + "]", e);
                }
                this.classCache.put(entry.getClassName(), entryClass);
            }
            if (!paramType.isAssignableFrom(entryClass)) {
                return null;
            }
        }
        try {
            return entry.getObject(space);
        }
        catch (UnusableEntryException e) {
            throw new FilterExecutionException("Failed to get object from entry [" + entry + "]", e);
        }
    }
}

