/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.core.space.mode;

import java.net.URL;
import java.net.URLClassLoader;
import org.jini.rio.boot.ServiceClassLoader;
import org.openspaces.core.space.mode.RefreshableContextLoader;
import org.openspaces.core.space.mode.SpaceModeContextLoader;

public class RefreshSpaceModeContextLoader
extends SpaceModeContextLoader
implements RefreshableContextLoader {
    private ClassLoader classLoader;
    private ClassLoader childAppContextClassLoader;

    @Override
    public void afterPropertiesSet() throws Exception {
        this.classLoader = Thread.currentThread().getContextClassLoader();
        super.afterPropertiesSet();
    }

    @Override
    protected void loadApplicationContext() throws Exception {
        if (this.applicationContext != null) {
            return;
        }
        if (this.classLoader.getClass().equals(URLClassLoader.class)) {
            URLClassLoader urlClassLoader = (URLClassLoader)this.classLoader;
            this.childAppContextClassLoader = new URLClassLoader(urlClassLoader.getURLs(), urlClassLoader.getParent());
        } else if (this.classLoader instanceof ServiceClassLoader) {
            ServiceClassLoader serviceClassLoader = (ServiceClassLoader)this.classLoader;
            String name = serviceClassLoader.getLogName();
            name = this.beanName != null ? name + "/" + this.beanName : name + "/{refreshable}";
            this.childAppContextClassLoader = new ServiceClassLoader(name, new URL[0], serviceClassLoader.getClassAnnotator(), (ClassLoader)serviceClassLoader);
            ((ServiceClassLoader)this.childAppContextClassLoader).setLibPath(serviceClassLoader.getLibPath());
            ((ServiceClassLoader)this.childAppContextClassLoader).setSlashPath(serviceClassLoader.getSlashPath());
        } else {
            this.logger.warn((Object)("Can't handle class loader [" + this.classLoader + "], context refreshing requires the service grid class loader or the url class loader. Context refreshing is disabled."));
            this.childAppContextClassLoader = this.classLoader;
        }
        ClassLoader origClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.childAppContextClassLoader);
        try {
            super.loadApplicationContext();
        }
        finally {
            Thread.currentThread().setContextClassLoader(origClassLoader);
        }
    }

    @Override
    protected void closeApplicationContext() {
        ClassLoader origClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.childAppContextClassLoader);
        try {
            super.closeApplicationContext();
        }
        finally {
            Thread.currentThread().setContextClassLoader(origClassLoader);
        }
    }

    @Override
    public void refresh() throws Exception {
        this.closeApplicationContext();
        this.loadApplicationContext();
    }
}

