/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.core.space.mode;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openspaces.core.GigaSpace;
import org.openspaces.core.cluster.ClusterInfo;
import org.openspaces.core.cluster.ClusterInfoAware;
import org.openspaces.core.properties.BeanLevelProperties;
import org.openspaces.core.properties.BeanLevelPropertiesAware;
import org.openspaces.core.space.mode.AbstractSpaceModeChangeEvent;
import org.openspaces.core.space.mode.AfterSpaceModeChangeEvent;
import org.openspaces.core.space.mode.BeforeSpaceModeChangeEvent;
import org.openspaces.core.util.SpaceUtils;
import org.openspaces.pu.container.ProcessingUnitContainerConfig;
import org.openspaces.pu.container.support.ResourceApplicationContext;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ApplicationEventMulticaster;
import org.springframework.context.support.AbstractApplicationContext;
import org.springframework.core.io.Resource;
import org.springframework.util.MethodInvoker;

public class SpaceModeContextLoader
implements ApplicationContextAware,
InitializingBean,
DisposableBean,
ApplicationListener,
BeanLevelPropertiesAware,
ClusterInfoAware,
BeanNameAware {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private Resource location;
    private GigaSpace gigaSpace;
    protected String beanName;
    private boolean activeWhenPrimary = true;
    private ApplicationContext parentApplicationContext;
    private ProcessingUnitContainerConfig config = new ProcessingUnitContainerConfig();
    protected volatile ResourceApplicationContext applicationContext;

    public void setLocation(Resource location) {
        this.location = location;
    }

    public void setGigaSpace(GigaSpace gigaSpace) {
        this.gigaSpace = gigaSpace;
    }

    public void setActiveWhenPrimary(boolean activeWhenPrimary) {
        this.activeWhenPrimary = activeWhenPrimary;
    }

    @Override
    public void setBeanLevelProperties(BeanLevelProperties beanLevelProperties) {
        this.config.setBeanLevelProperties(beanLevelProperties);
    }

    @Override
    public void setClusterInfo(ClusterInfo clusterInfo) {
        this.config.setClusterInfo(clusterInfo);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.parentApplicationContext = applicationContext;
    }

    public void setBeanName(String name) {
        this.beanName = name;
    }

    public void afterPropertiesSet() throws Exception {
        if (!this.activeWhenPrimary) {
            this.loadApplicationContext();
        }
    }

    public void destroy() throws Exception {
        this.closeApplicationContext();
    }

    public void onApplicationEvent(ApplicationEvent applicationEvent) {
        if (this.activeWhenPrimary) {
            if (applicationEvent instanceof AfterSpaceModeChangeEvent) {
                AfterSpaceModeChangeEvent spEvent = (AfterSpaceModeChangeEvent)applicationEvent;
                if (spEvent.isPrimary()) {
                    if (this.gigaSpace != null) {
                        if (SpaceUtils.isSameSpace(spEvent.getSpace(), this.gigaSpace.getSpace())) {
                            try {
                                this.loadApplicationContext();
                            }
                            catch (Exception e) {
                                this.logger.error((Object)("Failed to load context [" + this.location + "] when moving to primary mode"), (Throwable)e);
                            }
                        }
                    } else {
                        try {
                            this.loadApplicationContext();
                        }
                        catch (Exception e) {
                            this.logger.error((Object)("Failed to load context [" + this.location + "] when moving to primary mode"), (Throwable)e);
                        }
                    }
                }
                this.publishEvent(applicationEvent);
            } else if (applicationEvent instanceof BeforeSpaceModeChangeEvent) {
                this.publishEvent(applicationEvent);
                BeforeSpaceModeChangeEvent spEvent = (BeforeSpaceModeChangeEvent)applicationEvent;
                if (!spEvent.isPrimary()) {
                    if (this.gigaSpace != null) {
                        if (SpaceUtils.isSameSpace(spEvent.getSpace(), this.gigaSpace.getSpace())) {
                            this.closeApplicationContext();
                        }
                    } else {
                        this.closeApplicationContext();
                    }
                }
            }
        } else if (applicationEvent instanceof AbstractSpaceModeChangeEvent) {
            this.publishEvent(applicationEvent);
        }
    }

    protected void loadApplicationContext() throws Exception {
        if (this.applicationContext != null) {
            return;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Loading application context [" + this.location + "]"));
        }
        this.applicationContext = new ResourceApplicationContext(new Resource[]{this.location}, this.parentApplicationContext, this.config);
        try {
            this.applicationContext.refresh();
        }
        catch (Exception e) {
            this.applicationContext = null;
            throw e;
        }
    }

    protected void closeApplicationContext() {
        if (this.applicationContext != null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Closing application context [" + this.location + "]"));
            }
            try {
                this.applicationContext.setParent(null);
                this.applicationContext.close();
            }
            finally {
                this.applicationContext = null;
            }
        }
    }

    protected void publishEvent(ApplicationEvent applicationEvent) {
        ApplicationEventMulticaster eventMulticaster;
        if (this.applicationContext == null) {
            return;
        }
        try {
            MethodInvoker methodInvoker = new MethodInvoker();
            methodInvoker.setTargetClass(AbstractApplicationContext.class);
            methodInvoker.setTargetMethod("getApplicationEventMulticaster");
            methodInvoker.setTargetObject((Object)this.applicationContext);
            methodInvoker.setArguments(null);
            methodInvoker.prepare();
            eventMulticaster = (ApplicationEventMulticaster)methodInvoker.invoke();
        }
        catch (Exception e) {
            this.logger.warn((Object)"Failed to get application event multicaster to publish event to child application context", (Throwable)e);
            return;
        }
        eventMulticaster.multicastEvent(applicationEvent);
    }
}

