/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.core.space.mode.registry;

import java.lang.reflect.Method;
import org.openspaces.core.space.mode.PostBackup;
import org.openspaces.core.space.mode.PostPrimary;
import org.openspaces.core.space.mode.PreBackup;
import org.openspaces.core.space.mode.PrePrimary;
import org.openspaces.core.space.mode.registry.ModeAnnotationRegistry;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class ModeAnnotationRegistryPostProcessor
implements BeanPostProcessor,
ApplicationContextAware {
    private ApplicationContext applicationContext;

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        if (bean == null) {
            return bean;
        }
        ModeAnnotationRegistry registry = (ModeAnnotationRegistry)this.applicationContext.getBean("internal-modeAnnotationRegistry");
        if (registry != null) {
            Class<?> beanClass = this.getBeanClass(bean);
            if (beanClass == null) {
                return bean;
            }
            for (Method method : beanClass.getMethods()) {
                if (method.isAnnotationPresent(PreBackup.class)) {
                    registry.registerAnnotation(PreBackup.class, bean, method);
                }
                if (method.isAnnotationPresent(PrePrimary.class)) {
                    registry.registerAnnotation(PrePrimary.class, bean, method);
                }
                if (method.isAnnotationPresent(PostBackup.class)) {
                    registry.registerAnnotation(PostBackup.class, bean, method);
                }
                if (!method.isAnnotationPresent(PostPrimary.class)) continue;
                registry.registerAnnotation(PostPrimary.class, bean, method);
            }
        }
        return bean;
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    private Class<?> getBeanClass(Object bean) {
        return AopUtils.getTargetClass((Object)bean);
    }
}

