/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.core.space.status.registery;

import java.lang.reflect.Method;
import java.text.MessageFormat;
import org.openspaces.core.space.AbstractAnnotationRegistry;
import org.openspaces.core.space.status.SpaceStatusChanged;
import org.openspaces.core.space.status.SpaceStatusChangedEvent;
import org.openspaces.core.space.status.SpaceStatusChangedEventListener;

public class SpaceStatusChangedAnnotationRegistry
extends AbstractAnnotationRegistry
implements SpaceStatusChangedEventListener {
    @Override
    protected void validateMethod(Class<?> annotation, Method method) {
        Class<?>[] methodParametersTypes = method.getParameterTypes();
        this.validateAnnotationsType(annotation);
        this.validateMethodParameters(annotation, methodParametersTypes);
    }

    private void validateAnnotationsType(Class<?> annotationClass) {
        if (!annotationClass.equals(SpaceStatusChanged.class)) {
            throw new IllegalArgumentException("The specified annotation is not a space suspend type annotation: " + annotationClass);
        }
    }

    private void validateMethodParameters(Class<?> annotation, Class<?>[] methodParametersTypes) {
        boolean expectedNumOfParameters = true;
        if (methodParametersTypes.length != 1) {
            throw new IllegalArgumentException("The specified method has invalid number of parameters, A valid method may have a single parameter of type " + SpaceStatusChangedEvent.class.getName());
        }
        if (!methodParametersTypes[0].equals(SpaceStatusChangedEvent.class)) {
            String errorMsg = MessageFormat.format("Illegal target invocation method parameter type: {0}. A valid target invocation method for annotation {1} may have a single parameter of type {2}", methodParametersTypes[0].getName(), annotation.getSimpleName(), SpaceStatusChangedEvent.class.getName());
            throw new IllegalArgumentException(errorMsg);
        }
    }

    @Override
    public void onSpaceStatusChanged(SpaceStatusChangedEvent event) {
        this.fireEvent(SpaceStatusChanged.class, (Object)event);
    }
}

