/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.core.space.status.registery;

import java.lang.reflect.Method;
import org.openspaces.core.space.status.SpaceStatusChanged;
import org.openspaces.core.space.status.registery.SpaceStatusChangedAnnotationRegistry;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class SpaceStatusChangedAnnotationRegistryPostProcessor
implements BeanPostProcessor,
ApplicationContextAware {
    private ApplicationContext applicationContext;

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        if (bean == null) {
            return bean;
        }
        SpaceStatusChangedAnnotationRegistry registry = (SpaceStatusChangedAnnotationRegistry)this.applicationContext.getBean("internal-spaceStatusAnnotationRegistry");
        if (registry != null) {
            Class<?> beanClass = this.getBeanClass(bean);
            if (beanClass == null) {
                return bean;
            }
            for (Method method : beanClass.getMethods()) {
                if (!method.isAnnotationPresent(SpaceStatusChanged.class)) continue;
                registry.registerAnnotation(SpaceStatusChanged.class, bean, method);
            }
        }
        return bean;
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    private Class<?> getBeanClass(Object bean) {
        return AopUtils.getTargetClass((Object)bean);
    }
}

