/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.core.space.support;

import com.j_spaces.worker.IWorker;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openspaces.core.GigaSpace;
import org.openspaces.core.space.mode.AfterSpaceModeChangeEvent;
import org.openspaces.core.space.mode.BeforeSpaceModeChangeEvent;
import org.openspaces.core.util.SpaceUtils;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.util.Assert;

@Deprecated
public class WorkerAdapter
implements InitializingBean,
DisposableBean,
ApplicationListener {
    private static final Log logger = LogFactory.getLog(WorkerAdapter.class);
    private IWorker worker;
    private Thread thread;
    private String argument;
    private String workerName;
    private GigaSpace gigaSpace;
    private boolean activeWhenBackup = false;

    public void setWorker(IWorker worker) {
        this.worker = worker;
    }

    public void setGigaSpace(GigaSpace gigaSpace) {
        this.gigaSpace = gigaSpace;
    }

    public void setArgument(String argument) {
        this.argument = argument;
    }

    public void setWorkerName(String workerName) {
        this.workerName = workerName;
    }

    public void setActiveWhenBackup(boolean activeWhenBackup) {
        this.activeWhenBackup = activeWhenBackup;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.worker, (String)"worker is required");
        Assert.notNull((Object)this.worker, (String)"gigaSpace is required");
        if (this.activeWhenBackup) {
            this.startWorker();
        }
    }

    public void destroy() throws Exception {
        this.stopWorker();
    }

    public void onApplicationEvent(ApplicationEvent applicationEvent) {
        if (!this.activeWhenBackup) {
            BeforeSpaceModeChangeEvent spEvent;
            if (applicationEvent instanceof AfterSpaceModeChangeEvent) {
                AfterSpaceModeChangeEvent spEvent2 = (AfterSpaceModeChangeEvent)applicationEvent;
                if (spEvent2.isPrimary() && SpaceUtils.isSameSpace(spEvent2.getSpace(), this.gigaSpace.getSpace())) {
                    try {
                        this.startWorker();
                    }
                    catch (Exception e) {
                        logger.error((Object)("Failed to start worker [" + this.workerName + "]"), (Throwable)e);
                    }
                }
            } else if (applicationEvent instanceof BeforeSpaceModeChangeEvent && !(spEvent = (BeforeSpaceModeChangeEvent)applicationEvent).isPrimary() && SpaceUtils.isSameSpace(spEvent.getSpace(), this.gigaSpace.getSpace())) {
                this.stopWorker();
            }
        }
    }

    private void startWorker() throws Exception {
        if (this.thread == null) {
            this.worker.init(this.gigaSpace.getSpace(), this.workerName, this.argument);
            this.thread = new Thread((Runnable)this.worker);
            this.thread.setName(this.workerName + this.gigaSpace.getSpace().getName());
            this.thread.start();
        }
    }

    private void stopWorker() {
        if (this.thread == null) {
            return;
        }
        try {
            this.worker.close();
        }
        finally {
            this.thread = null;
        }
    }
}

