/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.core.transaction;

import com.gigaspaces.client.IsolationLevelModifiers;
import com.gigaspaces.client.transaction.DistributedTransactionManagerProvider;
import com.gigaspaces.internal.client.spaceproxy.ISpaceProxy;
import com.j_spaces.core.IJSpace;
import com.j_spaces.core.client.XAResourceImpl;
import java.io.IOException;
import java.rmi.RemoteException;
import java.util.List;
import javax.transaction.Transaction;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import net.jini.core.transaction.Transaction;
import net.jini.core.transaction.TransactionException;
import org.openspaces.core.IsolationLevelHelpers;
import org.openspaces.core.TransactionDataAccessException;
import org.openspaces.core.transaction.TransactionProvider;
import org.openspaces.core.transaction.manager.JiniPlatformTransactionManager;
import org.openspaces.core.transaction.manager.JiniTransactionHolder;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.jta.JtaTransactionManager;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationManager;

public class DefaultTransactionProvider
implements TransactionProvider {
    private final IJSpace space;
    private final Object actualTransactionalContext;
    private final PlatformTransactionManager transactionManager;
    private final boolean isJta;
    private DistributedTransactionManagerProvider distributedTransactionManagerProvider;
    private final Object distributedTransactionManagerProviderLock = new Object();

    public DefaultTransactionProvider(IJSpace space, PlatformTransactionManager transactionManager) {
        this(space, transactionManager instanceof JiniPlatformTransactionManager ? ((JiniPlatformTransactionManager)transactionManager).getTransactionalContext() : null, transactionManager);
    }

    public DefaultTransactionProvider(IJSpace space, Object actualTransactionalContext, PlatformTransactionManager transactionManager) {
        this.space = space;
        this.actualTransactionalContext = actualTransactionalContext;
        this.transactionManager = transactionManager;
        this.isJta = transactionManager != null && transactionManager instanceof JtaTransactionManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Transaction.Created getCurrentTransactionImpl() {
        JiniTransactionHolder txObject = (JiniTransactionHolder)((Object)TransactionSynchronizationManager.getResource((Object)"$existingTxContext"));
        if (txObject != null && txObject.hasTransaction()) {
            return txObject.getTxCreated();
        }
        if (this.actualTransactionalContext == null && !this.isJta) {
            return null;
        }
        if (!TransactionSynchronizationManager.isSynchronizationActive()) {
            return null;
        }
        if (this.isJta) {
            List txSynchronizations = TransactionSynchronizationManager.getSynchronizations();
            for (TransactionSynchronization txSynchronization : txSynchronizations) {
                SpaceAndTransactionSync spaceSync;
                if (!(txSynchronization instanceof SpaceAndTransactionSync) || !(spaceSync = (SpaceAndTransactionSync)txSynchronization).getSpace().equals(this.space)) continue;
                return spaceSync.getTransaction();
            }
            JtaTransactionManager jtaTransactionManager = (JtaTransactionManager)this.transactionManager;
            Transaction jtaTransaction = null;
            try {
                jtaTransaction = jtaTransactionManager.getTransactionManager().getTransaction();
            }
            catch (Exception e) {
                throw new TransactionDataAccessException("Failed to get JTA transaction", e);
            }
            if (jtaTransaction == null) {
                return null;
            }
            if (this.distributedTransactionManagerProvider == null) {
                Object e = this.distributedTransactionManagerProviderLock;
                synchronized (e) {
                    if (this.distributedTransactionManagerProvider == null) {
                        try {
                            this.distributedTransactionManagerProvider = new DistributedTransactionManagerProvider();
                        }
                        catch (TransactionException e2) {
                            throw new TransactionDataAccessException("Failed to get local transaction manager for space [" + this.space + "]", e2);
                        }
                    }
                }
            }
            XAResourceImpl xaResourceSpace = new XAResourceImpl(this.distributedTransactionManagerProvider.getTransactionManager(), this.space, true, false);
            if (jtaTransactionManager.getDefaultTimeout() != -1) {
                try {
                    xaResourceSpace.setTransactionTimeout(jtaTransactionManager.getDefaultTimeout() * 1000);
                }
                catch (XAException e) {
                    throw new TransactionDataAccessException("Failed to set default timeout of [" + jtaTransactionManager.getDefaultTimeout() * 1000 + "] on xa resource", e);
                }
            }
            try {
                jtaTransaction.enlistResource((XAResource)xaResourceSpace);
            }
            catch (Exception e) {
                throw new TransactionDataAccessException("Failed to enlist xa resource [" + xaResourceSpace + "] with space [" + this.space + "]", e);
            }
            Transaction.Created transaction = ((ISpaceProxy)this.space).getContextTransaction();
            TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)new SpaceAndTransactionSync(this.space, transaction));
            return transaction;
        }
        if (this.actualTransactionalContext == null) {
            return null;
        }
        txObject = (JiniTransactionHolder)((Object)TransactionSynchronizationManager.getResource((Object)this.actualTransactionalContext));
        if (txObject != null && txObject.hasTransaction()) {
            return txObject.getTxCreated();
        }
        return null;
    }

    public net.jini.core.transaction.Transaction getCurrentTransaction() {
        Transaction.Created result = this.getCurrentTransactionImpl();
        return result != null ? result.transaction : null;
    }

    @Override
    public Transaction.Created getCurrentTransaction(Object transactionalContext, IJSpace space) {
        return this.getCurrentTransactionImpl();
    }

    public PlatformTransactionManager getTransactionManager() {
        return this.transactionManager;
    }

    public JiniTransactionHolder getHolder() {
        if (this.isJta) {
            return null;
        }
        if (this.actualTransactionalContext == null) {
            return null;
        }
        JiniTransactionHolder txObject = (JiniTransactionHolder)((Object)TransactionSynchronizationManager.getResource((Object)"$existingTxContext"));
        if (txObject != null && txObject.hasTransaction()) {
            return txObject;
        }
        if (!TransactionSynchronizationManager.isSynchronizationActive()) {
            return null;
        }
        txObject = (JiniTransactionHolder)((Object)TransactionSynchronizationManager.getResource((Object)this.actualTransactionalContext));
        if (txObject != null && txObject.hasTransaction()) {
            return txObject;
        }
        return null;
    }

    public IsolationLevelModifiers getCurrentTransactionIsolationLevel() {
        if (this.actualTransactionalContext == null) {
            return null;
        }
        return IsolationLevelHelpers.fromSpringIsolationLevel(TransactionSynchronizationManager.getCurrentTransactionIsolationLevel());
    }

    @Override
    public int getCurrentTransactionIsolationLevel(Object transactionalContext) {
        return IsolationLevelHelpers.toSpringIsolationLevel(this.getCurrentTransactionIsolationLevel());
    }

    public boolean isEnabled() {
        if (this.actualTransactionalContext != null) {
            return true;
        }
        return this.isJta;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() throws RemoteException {
        Object object = this.distributedTransactionManagerProviderLock;
        synchronized (object) {
            if (this.distributedTransactionManagerProvider != null) {
                this.distributedTransactionManagerProvider.destroy();
            }
        }
    }

    public void close() throws IOException {
        this.destroy();
    }

    private static class SpaceAndTransactionSync
    implements TransactionSynchronization {
        private IJSpace space;
        private Transaction.Created transaction;

        public SpaceAndTransactionSync(IJSpace space, Transaction.Created transaction) {
            this.space = space;
            this.transaction = transaction;
        }

        public IJSpace getSpace() {
            return this.space;
        }

        public Transaction.Created getTransaction() {
            return this.transaction;
        }

        public void suspend() {
        }

        public void resume() {
        }

        public void beforeCommit(boolean readOnly) {
        }

        public void beforeCompletion() {
        }

        public void afterCommit() {
        }

        public void afterCompletion(int status) {
        }

        public void flush() {
        }
    }
}

