/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.core.transaction.internal;

import com.gigaspaces.async.AsyncFuture;
import com.gigaspaces.async.AsyncFutureListener;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import net.jini.core.transaction.Transaction;
import org.openspaces.core.GigaSpace;
import org.openspaces.core.transaction.internal.InternalAsyncFutureListener;
import org.springframework.dao.DataAccessException;

public class InternalAsyncFuture<T>
implements AsyncFuture<T> {
    private final AsyncFuture<T> future;
    private final GigaSpace gigaSpace;
    private final Transaction tx;

    public InternalAsyncFuture(AsyncFuture<T> future, GigaSpace gigaSpace) {
        this(future, gigaSpace, null);
    }

    public InternalAsyncFuture(AsyncFuture<T> future, GigaSpace gigaSpace, Transaction tx) {
        this.future = future;
        this.gigaSpace = gigaSpace;
        this.tx = tx;
    }

    public void setListener(AsyncFutureListener<T> listener) {
        if (this.tx != null) {
            this.future.setListener(InternalAsyncFutureListener.wrapIfNeeded(listener, this.gigaSpace));
        } else {
            this.future.setListener(listener);
        }
    }

    public boolean cancel(boolean mayInterruptIfRunning) {
        return this.future.cancel(mayInterruptIfRunning);
    }

    public boolean isCancelled() {
        return this.future.isCancelled();
    }

    public boolean isDone() {
        return this.future.isDone();
    }

    public T get() throws InterruptedException, ExecutionException {
        try {
            return this.get(-1L, TimeUnit.MILLISECONDS);
        }
        catch (TimeoutException e) {
            throw new ExecutionException(e);
        }
    }

    public T get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        try {
            if (timeout == -1L) {
                return (T)this.future.get();
            }
            return (T)this.future.get(timeout, unit);
        }
        catch (ExecutionException e) {
            DataAccessException translatedException = this.gigaSpace.getExceptionTranslator().translateNoUncategorized(e);
            if (translatedException != null) {
                e = new ExecutionException(e.getMessage(), (Throwable)translatedException);
            }
            throw e;
        }
    }
}

