/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.core.transaction.internal;

import com.gigaspaces.async.AsyncFutureListener;
import com.gigaspaces.async.AsyncResult;
import com.gigaspaces.async.internal.DefaultAsyncResult;
import net.jini.core.transaction.Transaction;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openspaces.core.GigaSpace;
import org.openspaces.core.transaction.DefaultTransactionProvider;
import org.openspaces.core.transaction.internal.TransactionalAsyncFutureListener;
import org.openspaces.core.transaction.manager.AbstractJiniTransactionManager;
import org.openspaces.core.transaction.manager.ExistingJiniTransactionManager;
import org.openspaces.core.transaction.manager.JiniTransactionHolder;
import org.springframework.dao.DataAccessException;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.DefaultTransactionStatus;

public class InternalAsyncFutureListener<T>
implements AsyncFutureListener<T> {
    private static final Log logger = LogFactory.getLog(InternalAsyncFutureListener.class);
    private final GigaSpace gigaSpace;
    private final AsyncFutureListener<T> listener;
    private final PlatformTransactionManager transactionManager;
    private final TransactionStatus txStatus;
    private final JiniTransactionHolder holder;
    private final boolean transactionalListener;

    public static <T> AsyncFutureListener<T> wrapIfNeeded(AsyncFutureListener<T> listener, GigaSpace gigaSpace) {
        DefaultTransactionProvider txProvider = (DefaultTransactionProvider)gigaSpace.getTxProvider();
        JiniTransactionHolder holder = txProvider.getHolder();
        PlatformTransactionManager transactionManager = txProvider.getTransactionManager();
        if (holder == null || transactionManager == null) {
            return new InternalAsyncFutureListener<T>(gigaSpace, listener, null, transactionManager, holder);
        }
        AbstractJiniTransactionManager.JiniTransactionObject jiniTransactionObject = new AbstractJiniTransactionManager.JiniTransactionObject();
        jiniTransactionObject.setJiniHolder(holder, false);
        DefaultTransactionStatus txStatus = new DefaultTransactionStatus((Object)jiniTransactionObject, true, false, false, false, null);
        holder.incRef();
        return new InternalAsyncFutureListener<T>(gigaSpace, listener, (TransactionStatus)txStatus, transactionManager, holder);
    }

    public InternalAsyncFutureListener(GigaSpace gigaSpace, AsyncFutureListener<T> listener) {
        this(gigaSpace, listener, null, null, null);
    }

    public InternalAsyncFutureListener(GigaSpace gigaSpace, AsyncFutureListener<T> listener, TransactionStatus txStatus, PlatformTransactionManager transactionManager, JiniTransactionHolder holder) {
        this.gigaSpace = gigaSpace;
        this.listener = listener;
        this.txStatus = txStatus;
        this.transactionManager = transactionManager;
        this.holder = holder;
        this.transactionalListener = listener instanceof TransactionalAsyncFutureListener;
    }

    private static Exception translate(Exception exception, GigaSpace gigaSpace) {
        if (exception == null) {
            return null;
        }
        DataAccessException translatedException = gigaSpace.getExceptionTranslator().translateNoUncategorized(exception);
        return translatedException != null ? translatedException : exception;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void onResult(AsyncResult<T> asyncResult) {
        DefaultAsyncResult result = new DefaultAsyncResult(asyncResult.getResult(), InternalAsyncFutureListener.translate(asyncResult.getException(), this.gigaSpace));
        Transaction tx = null;
        if (this.holder != null) {
            tx = this.holder.getTransaction();
        }
        if (tx != null) {
            try {
                ExistingJiniTransactionManager.bindExistingTransaction(tx, true, true);
                this.listener.onResult((AsyncResult)result);
                if (this.transactionalListener) {
                    ((TransactionalAsyncFutureListener)this.listener).onTransactionalResult(result, this.txStatus);
                }
                this.transactionManager.commit(this.txStatus);
                if (!this.transactionalListener) return;
                ((TransactionalAsyncFutureListener)this.listener).onPostCommitTransaction(result);
                return;
            }
            catch (RuntimeException e) {
                block12: {
                    try {
                        this.transactionManager.rollback(this.txStatus);
                    }
                    catch (RuntimeException e1) {
                        if (!logger.isDebugEnabled()) break block12;
                        logger.debug((Object)"Failed to rollback transaction after failed commit", (Throwable)e1);
                    }
                }
                if (!this.transactionalListener) throw e;
                ((TransactionalAsyncFutureListener)this.listener).onPostRollbackTransaction(result);
                throw e;
            }
            finally {
                ExistingJiniTransactionManager.unbindExistingTransactionIfPossible();
            }
        }
        this.listener.onResult((AsyncResult)result);
        if (!this.transactionalListener) return;
        try {
            ((TransactionalAsyncFutureListener)this.listener).onTransactionalResult(result, this.txStatus);
            ((TransactionalAsyncFutureListener)this.listener).onPostCommitTransaction(result);
            return;
        }
        catch (RuntimeException e) {
            ((TransactionalAsyncFutureListener)this.listener).onPostRollbackTransaction(result);
            throw e;
        }
    }
}

