/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.core.transaction.manager;

import java.rmi.RemoteException;
import net.jini.core.entry.UnusableEntryException;
import net.jini.core.lease.LeaseDeniedException;
import net.jini.core.lease.LeaseException;
import net.jini.core.lease.UnknownLeaseException;
import net.jini.core.transaction.CannotAbortException;
import net.jini.core.transaction.CannotCommitException;
import net.jini.core.transaction.TimeoutExpiredException;
import net.jini.core.transaction.Transaction;
import net.jini.core.transaction.TransactionFactory;
import net.jini.core.transaction.UnknownTransactionException;
import net.jini.core.transaction.server.NestableTransactionManager;
import net.jini.core.transaction.server.TransactionManager;
import net.jini.lease.LeaseRenewalManager;
import org.openspaces.core.transaction.manager.ExisitingJiniTransactionHolder;
import org.openspaces.core.transaction.manager.ExistingJiniTransactionManager;
import org.openspaces.core.transaction.manager.JiniPlatformTransactionManager;
import org.openspaces.core.transaction.manager.JiniTransactionHolder;
import org.openspaces.core.transaction.manager.TransactionLeaseRenewalConfig;
import org.openspaces.pu.service.ServiceDetailsProvider;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.remoting.RemoteAccessException;
import org.springframework.transaction.CannotCreateTransactionException;
import org.springframework.transaction.InvalidIsolationLevelException;
import org.springframework.transaction.NestedTransactionNotSupportedException;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionException;
import org.springframework.transaction.TransactionSystemException;
import org.springframework.transaction.TransactionTimedOutException;
import org.springframework.transaction.support.AbstractPlatformTransactionManager;
import org.springframework.transaction.support.DefaultTransactionStatus;
import org.springframework.transaction.support.SmartTransactionObject;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import org.springframework.util.Assert;

public abstract class AbstractJiniTransactionManager
extends AbstractPlatformTransactionManager
implements JiniPlatformTransactionManager,
InitializingBean,
BeanNameAware,
ServiceDetailsProvider,
DisposableBean {
    private static final long serialVersionUID = 4217156441204875733L;
    protected static final String SERVICE_TYPE = "tx-manager";
    static final long DEFAULT_TX_TIMEOUT = 90000L;
    static final long DEFAULT_TX_COMMIT_TIMEOUT = Long.MAX_VALUE;
    static final long DEFAULT_TX_ROLLBACK_TIMEOUT = Long.MAX_VALUE;
    private transient TransactionManager transactionManager;
    private Object transactionalContext;
    private Long commitTimeout = Long.MAX_VALUE;
    private Long rollbackTimeout = Long.MAX_VALUE;
    private TransactionLeaseRenewalConfig leaseRenewalConfig;
    private LeaseRenewalManager[] leaseRenewalManagers;
    protected String beanName;

    public void setBeanName(String beanName) {
        this.beanName = beanName;
    }

    @Override
    public String getBeanName() {
        return this.beanName;
    }

    @Override
    public Object getTransactionalContext() {
        return this.transactionalContext;
    }

    public void setTransactionalContext(Object txResource) {
        this.transactionalContext = txResource;
    }

    public void setCommitTimeout(Long commitTimeout) {
        this.commitTimeout = commitTimeout;
    }

    public void setRollbackTimeout(Long rollbackTimeout) {
        this.rollbackTimeout = rollbackTimeout;
    }

    public void setLeaseRenewalConfig(TransactionLeaseRenewalConfig leaseRenewalConfig) {
        this.leaseRenewalConfig = leaseRenewalConfig;
    }

    protected abstract TransactionManager doCreateTransactionManager() throws Exception;

    public TransactionManager getTransactionManager() {
        return this.transactionManager;
    }

    public void afterPropertiesSet() throws Exception {
        this.transactionManager = this.doCreateTransactionManager();
        Assert.notNull((Object)this.transactionManager, (String)"Jini transactionManager is required");
        if (this.transactionalContext == null) {
            this.transactionalContext = this.transactionManager;
        }
        if (this.transactionManager instanceof NestableTransactionManager) {
            this.setNestedTransactionAllowed(true);
        }
        if (this.leaseRenewalConfig != null) {
            this.leaseRenewalManagers = new LeaseRenewalManager[this.leaseRenewalConfig.getPoolSize()];
            for (int i = 0; i < this.leaseRenewalConfig.getPoolSize(); ++i) {
                this.leaseRenewalManagers[i] = new LeaseRenewalManager(this.leaseRenewalConfig.getRenewRTT(), 2L);
            }
            this.logger.debug((Object)this.logMessage("Created transaction manager with lease renewal pool [" + this.leaseRenewalConfig.getPoolSize() + "] and RTT [" + this.leaseRenewalConfig.getRenewRTT() + "]"));
        }
    }

    public void destroy() throws Exception {
        if (this.leaseRenewalManagers != null) {
            for (LeaseRenewalManager leaseRenewalManager : this.leaseRenewalManagers) {
                leaseRenewalManager.terminate();
            }
            this.leaseRenewalManagers = null;
        }
    }

    protected Object doGetTransaction() throws TransactionException {
        JiniTransactionObject txObject = new JiniTransactionObject();
        JiniTransactionHolder jiniHolder = (JiniTransactionHolder)((Object)TransactionSynchronizationManager.getResource((Object)this.transactionalContext));
        if (jiniHolder == null) {
            jiniHolder = (JiniTransactionHolder)((Object)TransactionSynchronizationManager.getResource((Object)"$existingTxContext"));
        }
        if (jiniHolder != null) {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)this.logMessage("Found thread-bound tx data [" + (Object)((Object)jiniHolder) + "] for Jini resource [" + this.transactionalContext + "]"));
            }
            txObject.setJiniHolder(jiniHolder, false);
        }
        return txObject;
    }

    protected void doBegin(Object transaction, TransactionDefinition definition) throws TransactionException {
        JiniTransactionObject txObject = (JiniTransactionObject)transaction;
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)this.logMessage("Beginning transaction [" + txObject + "]"));
        }
        try {
            this.doJiniBegin(txObject, definition);
        }
        catch (UnsupportedOperationException ex) {
            throw new NestedTransactionNotSupportedException("Implementation does not ex nested transactions", (Throwable)ex);
        }
    }

    protected void doJiniBegin(JiniTransactionObject txObject, TransactionDefinition definition) {
        try {
            if (txObject.getJiniHolder() == null) {
                Transaction.Created txCreated;
                long timeout = 90000L;
                if (this.getDefaultTimeout() != -1) {
                    timeout = (long)this.getDefaultTimeout() * 1000L;
                }
                if (definition.getTimeout() != -1) {
                    timeout = (long)definition.getTimeout() * 1000L;
                }
                if (this.logger.isTraceEnabled()) {
                    this.logger.trace((Object)this.logMessage("Creating new transaction for [" + this.transactionalContext + "] with timeout [" + timeout + " milliseconds]"));
                }
                LeaseRenewalManager leaseRenewalManager = null;
                if (this.leaseRenewalConfig != null) {
                    txCreated = TransactionFactory.create((TransactionManager)this.transactionManager, (long)this.leaseRenewalConfig.getRenewDuration());
                    leaseRenewalManager = this.leaseRenewalManagers[Math.abs(txCreated.hashCode() % this.leaseRenewalConfig.getPoolSize())];
                    leaseRenewalManager.renewFor(txCreated.lease, timeout, this.leaseRenewalConfig.getRenewDuration(), this.leaseRenewalConfig.getLeaseListener());
                } else {
                    txCreated = TransactionFactory.create((TransactionManager)this.transactionManager, (long)timeout);
                }
                JiniTransactionHolder jiniHolder = new JiniTransactionHolder(txCreated, definition.getIsolationLevel(), leaseRenewalManager);
                jiniHolder.setTimeoutInSeconds(definition.getTimeout());
                txObject.setJiniHolder(jiniHolder, true);
            }
            txObject.getJiniHolder().setSynchronizedWithTransaction(true);
            this.applyIsolationLevel(txObject, definition.getIsolationLevel());
            if (txObject.isNewJiniHolder()) {
                TransactionSynchronizationManager.bindResource((Object)this.transactionalContext, (Object)((Object)txObject.getJiniHolder()));
            }
        }
        catch (LeaseDeniedException e) {
            throw new CannotCreateTransactionException("Lease denied", (Throwable)e);
        }
        catch (RemoteException e) {
            throw new CannotCreateTransactionException("Remote exception", (Throwable)e);
        }
    }

    protected void applyIsolationLevel(JiniTransactionObject txObject, int isolationLevel) throws InvalidIsolationLevelException {
        if (isolationLevel != -1) {
            if (!this.suppportsCustomIsolationLevel()) {
                throw new InvalidIsolationLevelException(this.getClass().getName() + " does not support custom isolation levels");
            }
            if (isolationLevel == 8) {
                throw new InvalidIsolationLevelException("Jini Transaction Manager does not support serializable isolation level");
            }
        }
    }

    protected boolean suppportsCustomIsolationLevel() {
        return false;
    }

    protected void doCommit(DefaultTransactionStatus status) throws TransactionException {
        JiniTransactionObject txObject = (JiniTransactionObject)status.getTransaction();
        if (txObject.getJiniHolder().isDisableCommit()) {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)this.logMessage("Disabling commit on Jini transaction [" + txObject.toString() + "]"));
            }
            return;
        }
        if (txObject.getJiniHolder().decRef() > 0) {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)this.logMessage("Disabling commit on Jini transaction reference count is higher [" + txObject.toString() + "]"));
            }
            return;
        }
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)this.logMessage("Committing Jini transaction [" + txObject.toString() + "]"));
        }
        try {
            if (this.commitTimeout == null) {
                txObject.getTransaction().commit();
            } else {
                txObject.getTransaction().commit(this.commitTimeout.longValue());
            }
        }
        catch (UnknownTransactionException e) {
            throw this.convertJiniException((Exception)((Object)e));
        }
        catch (CannotCommitException e) {
            throw this.convertJiniException((Exception)((Object)e));
        }
        catch (RemoteException e) {
            throw this.convertJiniException(e);
        }
        catch (TimeoutExpiredException e) {
            throw this.convertJiniException((Exception)((Object)e));
        }
    }

    protected boolean isExistingTransaction(Object transaction) throws TransactionException {
        JiniTransactionObject txObject = (JiniTransactionObject)transaction;
        return txObject.hasTransaction();
    }

    protected void doRollback(DefaultTransactionStatus status) throws TransactionException {
        JiniTransactionObject txObject = (JiniTransactionObject)status.getTransaction();
        if (txObject.getJiniHolder().isDisableRollback()) {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)this.logMessage("Disabling rollback on Jini transaction [" + txObject.toString() + "]"));
            }
            return;
        }
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)this.logMessage("Rolling back Jini transaction [" + txObject + "]"));
        }
        try {
            if (this.rollbackTimeout == null) {
                txObject.getTransaction().abort();
            } else {
                txObject.getTransaction().abort(this.rollbackTimeout.longValue());
            }
        }
        catch (UnknownTransactionException e) {
            throw this.convertJiniException((Exception)((Object)e));
        }
        catch (CannotAbortException e) {
            throw this.convertJiniException((Exception)((Object)e));
        }
        catch (RemoteException e) {
            throw this.convertJiniException(e);
        }
        catch (TimeoutExpiredException e) {
            throw this.convertJiniException((Exception)((Object)e));
        }
        finally {
            txObject.getJiniHolder().setDisableCommit(true);
            txObject.getJiniHolder().setDisableRollback(true);
        }
    }

    protected void doCleanupAfterCompletion(Object transaction) {
        JiniTransactionObject txObject = (JiniTransactionObject)transaction;
        if (txObject.isNewJiniHolder()) {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace((Object)this.logMessage("Removing per-thread Jini transaction for [" + this.getTransactionalContext() + "]"));
            }
            TransactionSynchronizationManager.unbindResource((Object)this.getTransactionalContext());
            if (txObject.getJiniHolder().hasLeaseRenewalManager()) {
                try {
                    txObject.getJiniHolder().getLeaseRenewalManager().remove(txObject.getJiniHolder().getTxCreated().lease);
                }
                catch (UnknownLeaseException e) {
                    this.logger.debug((Object)this.logMessage("Got an unknown lease exception for [" + txObject + "]"), (Throwable)e);
                }
            }
        }
        txObject.getJiniHolder().clear();
    }

    protected void doSetRollbackOnly(DefaultTransactionStatus status) throws TransactionException {
        JiniTransactionObject txObject = (JiniTransactionObject)status.getTransaction();
        if (status.isDebug()) {
            this.logger.debug((Object)this.logMessage("Setting Jini transaction on txContext [" + this.getTransactionalContext() + "] rollback-only"));
        }
        txObject.setRollbackOnly();
    }

    protected void doResume(Object transaction, Object suspendedResources) throws TransactionException {
        if (suspendedResources instanceof ExisitingJiniTransactionHolder) {
            ExistingJiniTransactionManager.bindExistingTransaction((ExisitingJiniTransactionHolder)((Object)suspendedResources));
        } else {
            TransactionSynchronizationManager.bindResource((Object)this.getTransactionalContext(), (Object)((Object)((JiniTransactionHolder)((Object)suspendedResources))));
        }
    }

    protected Object doSuspend(Object transaction) throws TransactionException {
        JiniTransactionObject txObject = (JiniTransactionObject)transaction;
        txObject.setJiniHolder(null, false);
        Object unbindResource = TransactionSynchronizationManager.unbindResourceIfPossible((Object)this.getTransactionalContext());
        if (unbindResource == null) {
            unbindResource = TransactionSynchronizationManager.unbindResource((Object)"$existingTxContext");
        }
        return unbindResource;
    }

    protected boolean useSavepointForNestedTransaction() {
        return false;
    }

    protected RuntimeException convertJiniException(Exception exception) {
        if (exception instanceof LeaseException) {
            return new RemoteAccessException("Lease denied", (Throwable)exception);
        }
        if (exception instanceof TransactionException || exception instanceof net.jini.core.transaction.TransactionException) {
            return new TransactionSystemException(exception.getMessage(), (Throwable)exception);
        }
        if (exception instanceof RemoteException) {
            return new RemoteAccessException("RemoteException", (Throwable)exception);
        }
        if (exception instanceof UnusableEntryException) {
            return new RemoteAccessException("Unusable entry", (Throwable)exception);
        }
        if (exception instanceof RuntimeException) {
            return (RuntimeException)exception;
        }
        if (exception instanceof TimeoutExpiredException) {
            throw new TransactionTimedOutException("Transaction timed out (either the transaction or commit/abort)", (Throwable)exception);
        }
        return new UnexpectedTransactionException(exception);
    }

    protected String logMessage(String message) {
        return "[" + this.beanName + "] " + message;
    }

    public static class JiniTransactionObject
    implements SmartTransactionObject {
        private JiniTransactionHolder jiniHolder;
        private boolean newJiniHolder;

        public boolean hasTransaction() {
            return this.jiniHolder != null && this.jiniHolder.hasTransaction();
        }

        public void setJiniHolder(JiniTransactionHolder jiniHolder, boolean newSessionHolder) {
            this.jiniHolder = jiniHolder;
            this.newJiniHolder = newSessionHolder;
        }

        public JiniTransactionHolder getJiniHolder() {
            return this.jiniHolder;
        }

        public boolean isNewJiniHolder() {
            return this.newJiniHolder;
        }

        public boolean isRollbackOnly() {
            return this.jiniHolder != null && this.jiniHolder.isRollbackOnly();
        }

        public void setRollbackOnly() {
            if (this.jiniHolder != null) {
                this.jiniHolder.setRollbackOnly();
            }
        }

        public void flush() {
        }

        public Transaction getTransaction() {
            if (this.hasTransaction()) {
                return this.jiniHolder.getTxCreated().transaction;
            }
            return null;
        }
    }

    public static class UnexpectedTransactionException
    extends TransactionException {
        private static final long serialVersionUID = 1L;

        public UnexpectedTransactionException(Exception cause) {
            super("unexpected exception ", (Throwable)cause);
        }
    }
}

